/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNodePKGenerationAction;
import org.objectstyle.cayenne.access.DataNodeQueryAction;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryEngine;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.Transaction;
import org.objectstyle.cayenne.access.TransactionConnectionDecorator;
import org.objectstyle.cayenne.access.jdbc.BatchAction;
import org.objectstyle.cayenne.access.jdbc.ProcedureAction;
import org.objectstyle.cayenne.access.jdbc.RowDescriptor;
import org.objectstyle.cayenne.access.jdbc.SelectAction;
import org.objectstyle.cayenne.access.jdbc.UpdateAction;
import org.objectstyle.cayenne.access.trans.BatchQueryBuilder;
import org.objectstyle.cayenne.access.util.ResultDescriptor;
import org.objectstyle.cayenne.conn.PoolManager;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.map.AshwoodEntitySorter;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.EntitySorter;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.GenericSelectQuery;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SelectQuery;

public class DataNode
implements QueryEngine {
    public static final Class DEFAULT_ADAPTER_CLASS = JdbcAdapter.class;
    protected String name;
    protected DataSource dataSource;
    protected DbAdapter adapter;
    protected String dataSourceLocation;
    protected String dataSourceFactory;
    protected EntityResolver entityResolver;
    protected EntitySorter entitySorter;
    protected Map dataMaps;
    TransactionDataSource readThroughDataSource;
    DataNodePKGenerationAction pkGenerationAction;

    public DataNode() {
        this(null);
    }

    public DataNode(String name) {
        this.name = name;
        this.dataMaps = new HashMap();
        this.readThroughDataSource = new TransactionDataSource();
        this.entitySorter = new AshwoodEntitySorter(Collections.EMPTY_LIST);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataSourceLocation() {
        return this.dataSourceLocation;
    }

    public void setDataSourceLocation(String dataSourceLocation) {
        this.dataSourceLocation = dataSourceLocation;
    }

    public String getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(String dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataNodePKGenerationAction pkGenerationAction() {
        if (this.pkGenerationAction == null) {
            DataNode dataNode = this;
            synchronized (dataNode) {
                if (this.pkGenerationAction == null) {
                    this.pkGenerationAction = new DataNodePKGenerationAction(this);
                }
            }
        }
        return this.pkGenerationAction;
    }

    public Collection getDataMaps() {
        return Collections.unmodifiableCollection(this.dataMaps.values());
    }

    public void setDataMaps(Collection dataMaps) {
        Iterator it = dataMaps.iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            this.dataMaps.put(map.getName(), map);
        }
        this.entitySorter.setDataMaps(dataMaps);
    }

    public void addDataMap(DataMap map) {
        this.dataMaps.put(map.getName(), map);
        this.entitySorter.setDataMaps(this.getDataMaps());
    }

    public void removeDataMap(String mapName) {
        DataMap map = (DataMap)this.dataMaps.remove(mapName);
        if (map != null) {
            this.entitySorter.setDataMaps(this.getDataMaps());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource != null ? this.readThroughDataSource : null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public DataNode lookupDataNode(DataMap dataMap) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performQueries(Collection queries, OperationObserver observer, Transaction transaction) {
        Transaction old = Transaction.getThreadTransaction();
        Transaction.bindThreadTransaction(transaction);
        try {
            this.performQueries(queries, observer);
        }
        finally {
            Transaction.bindThreadTransaction(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performQueries(Collection queries, OperationObserver callback) {
        int listSize = queries.size();
        if (listSize == 0) {
            return;
        }
        if (callback.isIteratedResult() && listSize > 1) {
            throw new CayenneRuntimeException("Iterated queries are not allowed in a batch. Batch size: " + listSize);
        }
        QueryLogger.logQueryStart(listSize);
        this.getAdapter().getExtendedTypes();
        Connection connection = null;
        try {
            connection = this.getDataSource().getConnection();
        }
        catch (Exception globalEx) {
            QueryLogger.logQueryError(globalEx);
            Transaction transaction = Transaction.getThreadTransaction();
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
            callback.nextGlobalException(globalEx);
            return;
        }
        try {
            DataNodeQueryAction queryRunner = new DataNodeQueryAction(this, callback);
            Iterator it = queries.iterator();
            while (it.hasNext()) {
                Query nextQuery = (Query)it.next();
                try {
                    queryRunner.runQuery(connection, nextQuery);
                }
                catch (Exception queryEx) {
                    QueryLogger.logQueryError(queryEx);
                    callback.nextQueryException(nextQuery, queryEx);
                    Transaction transaction = Transaction.getThreadTransaction();
                    if (transaction != null) {
                        transaction.setRollbackOnly();
                    }
                    break;
                }
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {}
        }
    }

    protected void runSelect(Connection connection, Query query, OperationObserver observer) throws SQLException, Exception {
        new SelectAction((SelectQuery)query, this.getAdapter(), this.getEntityResolver()).performAction(connection, observer);
    }

    protected void runUpdate(Connection con, Query query, OperationObserver delegate) throws SQLException, Exception {
        new UpdateAction(query, this.getAdapter(), this.getEntityResolver()).performAction(con, delegate);
    }

    protected void runBatchUpdate(Connection connection, BatchQuery query, OperationObserver observer) throws SQLException, Exception {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        BatchAction action = new BatchAction(query, this.getAdapter(), this.getEntityResolver());
        action.setBatch(runningAsBatch);
        action.performAction(connection, observer);
    }

    protected void runBatchUpdateAsBatch(Connection con, BatchQuery query, BatchQueryBuilder queryBuilder, OperationObserver delegate) throws SQLException, Exception {
        new TempBatchAction(query, true).runAsBatch(con, queryBuilder, delegate);
    }

    protected void runBatchUpdateAsIndividualQueries(Connection con, BatchQuery query, BatchQueryBuilder queryBuilder, OperationObserver delegate) throws SQLException, Exception {
        new TempBatchAction(query, false).runAsBatch(con, queryBuilder, delegate);
    }

    protected void runStoredProcedure(Connection con, Query query, OperationObserver delegate) throws SQLException, Exception {
        new ProcedureAction((ProcedureQuery)query, this.getAdapter(), this.getEntityResolver()).performAction(con, delegate);
    }

    protected void readStoredProcedureOutParameters(CallableStatement statement, ResultDescriptor descriptor, Query query, OperationObserver delegate) throws SQLException, Exception {
        new TempProcedureAction((ProcedureQuery)query).readProcedureOutParameters(statement, delegate);
    }

    protected void readResultSet(ResultSet resultSet, ResultDescriptor descriptor, GenericSelectQuery query, OperationObserver delegate) throws SQLException, Exception {
        RowDescriptor rowDescriptor = new RowDescriptor(resultSet, this.getAdapter().getExtendedTypes());
        new TempProcedureAction((ProcedureQuery)query).readResultSet(resultSet, rowDescriptor, query, delegate);
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntitySorter getEntitySorter() {
        return this.entitySorter;
    }

    public void setEntitySorter(EntitySorter entitySorter) {
        this.entitySorter = entitySorter;
    }

    public synchronized void shutdown() {
        DataSource ds = this.getDataSource();
        try {
            if (ds instanceof PoolManager) {
                ((PoolManager)ds).dispose();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    final class TransactionDataSource
    implements DataSource {
        final String CONNECTION_RESOURCE_PREFIX = "DataNode.Connection.";

        TransactionDataSource() {
        }

        public Connection getConnection() throws SQLException {
            Transaction t = Transaction.getThreadTransaction();
            if (t != null) {
                String key = "DataNode.Connection." + DataNode.this.name;
                Connection c = t.getConnection(key);
                if (c == null || c.isClosed()) {
                    c = DataNode.this.dataSource.getConnection();
                    t.addConnection(key, c);
                }
                return new TransactionConnectionDecorator(c);
            }
            return DataNode.this.dataSource.getConnection();
        }

        public Connection getConnection(String username, String password) throws SQLException {
            Transaction t = Transaction.getThreadTransaction();
            if (t != null) {
                String key = "DataNode.Connection." + DataNode.this.name;
                Connection c = t.getConnection(key);
                if (c == null || c.isClosed()) {
                    c = DataNode.this.dataSource.getConnection();
                    t.addConnection(key, c);
                }
                return new TransactionConnectionDecorator(c);
            }
            return DataNode.this.dataSource.getConnection(username, password);
        }

        public int getLoginTimeout() throws SQLException {
            return DataNode.this.dataSource.getLoginTimeout();
        }

        public PrintWriter getLogWriter() throws SQLException {
            return DataNode.this.dataSource.getLogWriter();
        }

        public void setLoginTimeout(int seconds) throws SQLException {
            DataNode.this.dataSource.setLoginTimeout(seconds);
        }

        public void setLogWriter(PrintWriter out) throws SQLException {
            DataNode.this.dataSource.setLogWriter(out);
        }
    }

    final class TempBatchAction
    extends BatchAction {
        public TempBatchAction(BatchQuery batchQuery, boolean runningAsBatch) {
            super(batchQuery, DataNode.this.adapter, DataNode.this.entityResolver);
            this.setBatch(runningAsBatch);
        }

        protected void runAsBatch(Connection con, BatchQueryBuilder queryBuilder, OperationObserver delegate) throws SQLException, Exception {
            super.runAsBatch(con, queryBuilder, delegate);
        }

        public void runAsIndividualQueries(Connection con, BatchQueryBuilder queryBuilder, OperationObserver delegate) throws SQLException, Exception {
            super.runAsIndividualQueries(con, queryBuilder, delegate, false);
        }
    }

    final class TempProcedureAction
    extends ProcedureAction {
        public TempProcedureAction(ProcedureQuery query) {
            super(query, DataNode.this.adapter, DataNode.this.entityResolver);
        }

        public void readProcedureOutParameters(CallableStatement statement, OperationObserver delegate) throws SQLException, Exception {
            super.readProcedureOutParameters(statement, delegate);
        }

        public void readResultSet(ResultSet resultSet, RowDescriptor descriptor, Query query, OperationObserver delegate) throws SQLException, Exception {
            super.readResultSet(resultSet, descriptor, query, delegate);
        }
    }
}

