/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ComparatorUtils;
import org.objectstyle.ashwood.graph.CollectionFactory;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.IndegreeTopologicalSort;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.StrongConnection;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;

class DataNodePKGenerationAction {
    private Map indexedDbEntities;
    private DataNode node;
    private DbEntityComparator dbEntityComparator;
    private ObjEntityComparator objEntityComparator;

    DataNodePKGenerationAction(DataNode node) {
        this.node = node;
        this.init(node.getDataMaps());
        this.dbEntityComparator = new DbEntityComparator();
        this.objEntityComparator = new ObjEntityComparator();
    }

    Comparator getDbEntityComparator() {
        return this.dbEntityComparator;
    }

    Comparator getObjEntityComparator() {
        return this.objEntityComparator;
    }

    void createPermIdsForObjEntity(ObjEntity objEntity, List dataObjects) {
        if (dataObjects.isEmpty()) {
            return;
        }
        DbEntity dbEntity = objEntity.getDbEntity();
        PkGenerator pkGenerator = this.node.getAdapter().getPkGenerator();
        boolean supportsGeneratedKeys = this.node.getAdapter().supportsGeneratedKeys();
        List pkAttributes = dbEntity.getPrimaryKey();
        boolean pkFromMaster = true;
        Iterator i = dataObjects.iterator();
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            ObjectId id = object.getObjectId();
            if (id == null || !id.isTemporary()) continue;
            Map idMap = id.getReplacementIdMap();
            if (pkFromMaster) {
                pkFromMaster = this.appendPkFromMasterRelationships(idMap, object, objEntity, dbEntity, supportsGeneratedKeys);
            }
            boolean autoPkDone = false;
            Iterator it = pkAttributes.iterator();
            while (it.hasNext()) {
                DbAttribute dbAttr = (DbAttribute)it.next();
                String dbAttrName = dbAttr.getName();
                if (idMap.containsKey(dbAttrName)) continue;
                if (supportsGeneratedKeys && dbAttr.isGenerated()) {
                    idMap.put(dbAttrName, null);
                    continue;
                }
                ObjAttribute objAttr = objEntity.getAttributeForDbAttribute(dbAttr);
                if (objAttr != null) {
                    idMap.put(dbAttrName, object.readPropertyDirectly(objAttr.getName()));
                    continue;
                }
                if (autoPkDone) {
                    throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.");
                }
                try {
                    Object pkValue = pkGenerator.generatePkForDbEntity(this.node, dbEntity);
                    idMap.put(dbAttrName, pkValue);
                    autoPkDone = true;
                }
                catch (Exception ex) {
                    throw new CayenneRuntimeException("Error generating PK: " + ex.getMessage(), ex);
                }
            }
        }
    }

    private boolean appendPkFromMasterRelationships(Map idMap, DataObject dataObject, ObjEntity objEntity, DbEntity dbEntity, boolean supportsGeneratedKeys) throws CayenneRuntimeException {
        boolean useful = false;
        Iterator it = dbEntity.getRelationships().iterator();
        while (it.hasNext()) {
            ObjRelationship rel;
            DbRelationship dbRel = (DbRelationship)it.next();
            if (!dbRel.isToMasterPK() || (rel = objEntity.getRelationshipForDbRelationship(dbRel)) == null) continue;
            DataObject targetDo = (DataObject)dataObject.readPropertyDirectly(rel.getName());
            if (targetDo == null) {
                throw new CayenneRuntimeException("Null master object, can't create primary key for: " + dataObject.getClass() + "." + dbRel.getName());
            }
            ObjectId targetKey = targetDo.getObjectId();
            Map targetKeyMap = targetKey.getIdSnapshot();
            if (targetKeyMap == null) {
                throw new CayenneRuntimeException(this.noMasterPkMsg(objEntity.getName(), targetKey.getEntityName(), dbRel.getName()));
            }
            Iterator joins = dbRel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                Object value = targetKeyMap.get(join.getTargetName());
                if (value == null) {
                    if (supportsGeneratedKeys && join.getTarget().isGenerated()) continue;
                    throw new CayenneRuntimeException("Some parts of FK are missing in snapshot, join: " + join);
                }
                idMap.put(join.getSourceName(), value);
            }
            useful = true;
        }
        return useful;
    }

    private String noMasterPkMsg(String src, String dst, String rel) {
        StringBuffer msg = new StringBuffer("Can't create primary key, master object has no PK snapshot.");
        msg.append("\nrelationship name: ").append(rel).append(", src object: ").append(src).append(", target obj: ").append(dst);
        return msg.toString();
    }

    private void init(Collection dataMaps) {
        ArrayList dbEntitiesToResolve = new ArrayList(32);
        Iterator i = dataMaps.iterator();
        while (i.hasNext()) {
            dbEntitiesToResolve.addAll(((DataMap)i.next()).getDbEntities());
        }
        MapDigraph pkDependencyGraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        this.indexedDbEntities = new HashMap(dbEntitiesToResolve.size());
        Iterator i2 = dbEntitiesToResolve.iterator();
        while (i2.hasNext()) {
            DbEntity origin = (DbEntity)i2.next();
            Iterator j = origin.getRelationships().iterator();
            while (j.hasNext()) {
                DbEntity dst;
                DbRelationship relation = (DbRelationship)j.next();
                if (!relation.isToDependentPK() || origin.equals(dst = (DbEntity)relation.getTargetEntity())) continue;
                pkDependencyGraph.putArc(origin, dst, Boolean.TRUE);
            }
        }
        int index = 0;
        Iterator i3 = dbEntitiesToResolve.iterator();
        while (i3.hasNext()) {
            DbEntity entity = (DbEntity)i3.next();
            if (pkDependencyGraph.containsVertex(entity)) continue;
            this.indexedDbEntities.put(entity, new Integer(index++));
        }
        boolean acyclic = GraphUtils.isAcyclic(pkDependencyGraph);
        if (acyclic) {
            IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(pkDependencyGraph);
            while (sorter.hasNext()) {
                this.indexedDbEntities.put(sorter.next(), new Integer(index++));
            }
        } else {
            StrongConnection contractor = new StrongConnection(pkDependencyGraph, CollectionFactory.ARRAYLIST_FACTORY);
            MapDigraph contractedDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
            contractor.contract(contractedDigraph, CollectionFactory.ARRAYLIST_FACTORY);
            IndegreeTopologicalSort sorter = new IndegreeTopologicalSort(contractedDigraph);
            while (sorter.hasNext()) {
                Collection component = (Collection)sorter.next();
                Iterator i4 = component.iterator();
                while (i4.hasNext()) {
                    this.indexedDbEntities.put(i4.next(), new Integer(index++));
                }
            }
        }
    }

    private class ObjEntityComparator
    implements Comparator {
        private ObjEntityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            DbEntity e1 = ((ObjEntity)o1).getDbEntity();
            DbEntity e2 = ((ObjEntity)o2).getDbEntity();
            return DataNodePKGenerationAction.this.dbEntityComparator.compare(e1, e2);
        }
    }

    private class DbEntityComparator
    implements Comparator {
        private DbEntityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            Integer index1 = (Integer)DataNodePKGenerationAction.this.indexedDbEntities.get(o1);
            Integer index2 = (Integer)DataNodePKGenerationAction.this.indexedDbEntities.get(o2);
            return ComparatorUtils.NATURAL_COMPARATOR.compare(index1, index2);
        }
    }
}

