/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.QueryEngine;
import org.objectstyle.cayenne.access.event.SnapshotEvent;
import org.objectstyle.cayenne.event.EventBridge;
import org.objectstyle.cayenne.event.EventBridgeFactory;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.event.EventSubject;
import org.objectstyle.cayenne.query.ObjectIdQuery;

public class DataRowStore
implements Serializable {
    private static Logger logObj = Logger.getLogger(DataRowStore.class);
    public static final String SNAPSHOT_EXPIRATION_PROPERTY = "cayenne.DataRowStore.snapshot.expiration";
    public static final String SNAPSHOT_CACHE_SIZE_PROPERTY = "cayenne.DataRowStore.snapshot.size";
    public static final String REMOTE_NOTIFICATION_PROPERTY = "cayenne.DataRowStore.remote.notify";
    public static final String EVENT_BRIDGE_FACTORY_PROPERTY = "cayenne.DataRowStore.EventBridge.factory";
    public static final long SNAPSHOT_EXPIRATION_DEFAULT = 7200L;
    public static final int SNAPSHOT_CACHE_SIZE_DEFAULT = 10000;
    public static final boolean REMOTE_NOTIFICATION_DEFAULT = false;
    public static final String EVENT_BRIDGE_FACTORY_DEFAULT = "org.objectstyle.cayenne.event.JavaGroupsBridgeFactory";
    protected String name;
    protected LRUMap snapshots;
    protected LRUMap snapshotLists;
    protected boolean notifyingRemoteListeners;
    protected transient EventManager eventManager;
    protected transient EventBridge remoteNotificationsHandler;
    protected transient EventSubject eventSubject;

    public DataRowStore(String name) {
        this(name, Collections.EMPTY_MAP);
    }

    public DataRowStore(String name, Map properties) {
        this(name, properties, new EventManager());
    }

    public DataRowStore(String name, Map properties, EventManager eventManager) {
        if (name == null) {
            throw new IllegalArgumentException("DataRowStore name can't be null.");
        }
        this.name = name;
        this.eventSubject = this.createSubject();
        this.eventManager = eventManager;
        this.initWithProperties(properties);
    }

    private EventSubject createSubject() {
        return EventSubject.getSubject(this.getClass(), this.name);
    }

    protected void initWithProperties(Map properties) {
        ExtendedProperties propertiesWrapper = new ExtendedProperties();
        if (properties != null) {
            propertiesWrapper.putAll(properties);
        }
        long snapshotsExpiration = propertiesWrapper.getLong(SNAPSHOT_EXPIRATION_PROPERTY, 7200L);
        int snapshotsCacheSize = propertiesWrapper.getInt(SNAPSHOT_CACHE_SIZE_PROPERTY, 10000);
        boolean notifyRemote = propertiesWrapper.getBoolean(REMOTE_NOTIFICATION_PROPERTY, false);
        String eventBridgeFactory = propertiesWrapper.getString(EVENT_BRIDGE_FACTORY_PROPERTY, EVENT_BRIDGE_FACTORY_DEFAULT);
        if (logObj.isDebugEnabled()) {
            logObj.debug("DataRowStore property cayenne.DataRowStore.snapshot.expiration = " + snapshotsExpiration);
            logObj.debug("DataRowStore property cayenne.DataRowStore.snapshot.size = " + snapshotsCacheSize);
            logObj.debug("DataRowStore property cayenne.DataRowStore.remote.notify = " + notifyRemote);
            logObj.debug("DataRowStore property cayenne.DataRowStore.EventBridge.factory = " + eventBridgeFactory);
        }
        this.notifyingRemoteListeners = notifyRemote;
        this.snapshots = new LRUMap(snapshotsCacheSize);
        this.snapshotLists = new LRUMap(snapshotsCacheSize);
        if (this.notifyingRemoteListeners) {
            try {
                EventBridgeFactory factory = (EventBridgeFactory)Class.forName(eventBridgeFactory).newInstance();
                Set<EventSubject> subjects = Collections.singleton(this.getSnapshotEventSubject());
                String externalSubject = EventBridge.convertToExternalSubject(this.getSnapshotEventSubject());
                this.remoteNotificationsHandler = factory.createEventBridge(subjects, externalSubject, properties);
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error initializing DataRowStore.", ex);
            }
            this.startListeners();
        }
    }

    public int size() {
        return this.snapshots.size();
    }

    public int maximumSize() {
        return this.snapshots.maxSize();
    }

    public void shutdown() {
        this.stopListeners();
        this.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        if (eventManager != this.eventManager) {
            this.stopListeners();
            this.eventManager = eventManager;
            this.startListeners();
        }
    }

    public synchronized DataRow getCachedSnapshot(ObjectId oid) {
        return (DataRow)this.snapshots.get(oid);
    }

    public synchronized DataRow getSnapshot(ObjectId oid, QueryEngine engine) {
        if (engine instanceof DataChannel) {
            return this.getSnapshot(oid, (DataChannel)((Object)engine));
        }
        if (engine instanceof DataContext) {
            return this.getSnapshot(oid, ((DataContext)engine).getChannel());
        }
        throw new CayenneRuntimeException("QueryEngine is not an DataChannel or DataContext: " + engine);
    }

    private DataRow getSnapshot(ObjectId oid, DataChannel channel) {
        ObjectIdQuery query;
        List results;
        DataRow cachedSnapshot = this.getCachedSnapshot(oid);
        if (cachedSnapshot != null) {
            return cachedSnapshot;
        }
        if (logObj.isDebugEnabled()) {
            logObj.debug("no cached snapshot for ObjectId: " + oid);
        }
        if ((results = channel.onQuery(null, query = new ObjectIdQuery(oid, true, 2)).firstList()).size() > 1) {
            throw new CayenneRuntimeException("More than 1 object found for ObjectId " + oid + ". Fetch matched " + results.size() + " objects.");
        }
        if (results.size() == 0) {
            return null;
        }
        DataRow snapshot = (DataRow)results.get(0);
        this.snapshots.put(oid, snapshot);
        return snapshot;
    }

    public void cacheSnapshots(String key, List snapshots) {
        this.snapshotLists.put(key, snapshots);
    }

    public List getCachedSnapshots(String key) {
        if (key == null) {
            return null;
        }
        return (List)this.snapshotLists.get(key);
    }

    public EventSubject getSnapshotEventSubject() {
        return this.eventSubject;
    }

    public synchronized void clear() {
        this.snapshots.clear();
        this.snapshotLists.clear();
    }

    public synchronized void forgetSnapshot(ObjectId id) {
        this.snapshots.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoteEvent(SnapshotEvent event) {
        if (event.getSource() != this.remoteNotificationsHandler) {
            return;
        }
        if (logObj.isDebugEnabled()) {
            logObj.debug("remote event: " + event);
        }
        Collection deletedSnapshotIds = event.getDeletedIds();
        Collection invalidatedSnapshotIds = event.getInvalidatedIds();
        Map diffs = event.getModifiedDiffs();
        Collection indirectlyModifiedIds = event.getIndirectlyModifiedIds();
        if (deletedSnapshotIds.isEmpty() && invalidatedSnapshotIds.isEmpty() && diffs.isEmpty() && indirectlyModifiedIds.isEmpty()) {
            logObj.warn("processRemoteEvent.. bogus call... no changes.");
            return;
        }
        DataRowStore dataRowStore = this;
        synchronized (dataRowStore) {
            this.processDeletedIDs(deletedSnapshotIds);
            this.processInvalidatedIDs(deletedSnapshotIds);
            this.processUpdateDiffs(diffs);
            this.sendUpdateNotification(event.getPostedBy(), diffs, deletedSnapshotIds, invalidatedSnapshotIds, indirectlyModifiedIds);
        }
    }

    public void processSnapshotChanges(Object source, Map updatedSnapshots, Collection deletedSnapshotIds, Collection indirectlyModifiedIds) {
        this.processSnapshotChanges(source, updatedSnapshots, deletedSnapshotIds, Collections.EMPTY_LIST, indirectlyModifiedIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSnapshotChanges(Object postedBy, Map updatedSnapshots, Collection deletedSnapshotIds, Collection invalidatedSnapshotIds, Collection indirectlyModifiedIds) {
        if (deletedSnapshotIds.isEmpty() && invalidatedSnapshotIds.isEmpty() && updatedSnapshots.isEmpty() && indirectlyModifiedIds.isEmpty()) {
            logObj.warn("postSnapshotsChangeEvent.. bogus call... no changes.");
            return;
        }
        DataRowStore dataRowStore = this;
        synchronized (dataRowStore) {
            this.processDeletedIDs(deletedSnapshotIds);
            this.processInvalidatedIDs(invalidatedSnapshotIds);
            Map diffs = this.processUpdatedSnapshots(updatedSnapshots);
            this.sendUpdateNotification(postedBy, diffs, deletedSnapshotIds, invalidatedSnapshotIds, indirectlyModifiedIds);
        }
    }

    private void processDeletedIDs(Collection deletedSnapshotIDs) {
        if (!deletedSnapshotIDs.isEmpty()) {
            Iterator it = deletedSnapshotIDs.iterator();
            while (it.hasNext()) {
                this.snapshots.remove(it.next());
            }
        }
    }

    private void processInvalidatedIDs(Collection invalidatedSnapshotIds) {
        if (!invalidatedSnapshotIds.isEmpty()) {
            Iterator it = invalidatedSnapshotIds.iterator();
            while (it.hasNext()) {
                this.snapshots.remove(it.next());
            }
        }
    }

    private Map processUpdatedSnapshots(Map updatedSnapshots) {
        HashMap<ObjectId, DataRow> diffs = null;
        if (!updatedSnapshots.isEmpty()) {
            Iterator it = updatedSnapshots.entrySet().iterator();
            while (it.hasNext()) {
                DataRow newSnapshot;
                Map.Entry entry = it.next();
                ObjectId key = (ObjectId)entry.getKey();
                DataRow oldSnapshot = (DataRow)this.snapshots.put(key, newSnapshot = (DataRow)entry.getValue());
                if (oldSnapshot == null) continue;
                if (oldSnapshot.getVersion() != newSnapshot.getReplacesVersion()) {
                    logObj.debug("snapshot version changed, don't know what to do... Old: " + oldSnapshot + ", New: " + newSnapshot);
                    this.forgetSnapshot(key);
                    continue;
                }
                DataRow diff = oldSnapshot.createDiff(newSnapshot);
                if (diff == null) continue;
                if (diffs == null) {
                    diffs = new HashMap<ObjectId, DataRow>();
                }
                diffs.put(key, diff);
            }
        }
        return diffs;
    }

    private void processUpdateDiffs(Map diffs) {
        if (!diffs.isEmpty()) {
            Iterator it = diffs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjectId key = (ObjectId)entry.getKey();
                DataRow oldSnapshot = (DataRow)this.snapshots.remove(key);
                if (oldSnapshot == null) continue;
                DataRow newSnapshot = oldSnapshot.applyDiff((DataRow)entry.getValue());
                this.snapshots.put(key, newSnapshot);
            }
        }
    }

    private void sendUpdateNotification(Object postedBy, Map diffs, Collection deletedSnapshotIDs, Collection invalidatedSnapshotIDs, Collection indirectlyModifiedIds) {
        if (diffs != null && !diffs.isEmpty() || deletedSnapshotIDs != null && !deletedSnapshotIDs.isEmpty() || invalidatedSnapshotIDs != null && !invalidatedSnapshotIDs.isEmpty() || indirectlyModifiedIds != null && !indirectlyModifiedIds.isEmpty()) {
            SnapshotEvent event = new SnapshotEvent(this, postedBy, diffs, deletedSnapshotIDs, invalidatedSnapshotIDs, indirectlyModifiedIds);
            if (logObj.isDebugEnabled()) {
                logObj.debug("postSnapshotsChangeEvent: " + event);
            }
            this.eventManager.postEvent(event, this.getSnapshotEventSubject());
        }
    }

    public boolean isNotifyingRemoteListeners() {
        return this.notifyingRemoteListeners;
    }

    public void setNotifyingRemoteListeners(boolean notifyingRemoteListeners) {
        this.notifyingRemoteListeners = notifyingRemoteListeners;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.eventSubject = this.createSubject();
    }

    void stopListeners() {
        this.eventManager.removeListener(this);
        if (this.remoteNotificationsHandler != null) {
            try {
                this.remoteNotificationsHandler.shutdown();
            }
            catch (Exception ex) {
                logObj.info("Exception shutting down EventBridge.", ex);
            }
            this.remoteNotificationsHandler = null;
        }
    }

    void startListeners() {
        if (this.remoteNotificationsHandler != null) {
            try {
                this.eventManager.addNonBlockingListener(this, "processRemoteEvent", SnapshotEvent.class, this.getSnapshotEventSubject(), this.remoteNotificationsHandler);
                this.remoteNotificationsHandler.startup(this.eventManager, 3);
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error initializing DataRowStore.", ex);
            }
        }
    }
}

