/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataRowStore;
import org.objectstyle.cayenne.access.DataRowUtils;
import org.objectstyle.cayenne.access.ObjectStore;
import org.objectstyle.cayenne.access.PrefetchProcessorNode;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityInheritanceTree;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;

class ObjectResolver {
    DataContext context;
    ObjEntity entity;
    EntityInheritanceTree inheritanceTree;
    boolean refreshObjects;
    boolean resolveInheritance;

    ObjectResolver(DataContext context, Query query) {
        EntityResolver resolver = context.getEntityResolver();
        QueryMetadata metadata = query.getMetaData(resolver);
        this.init(context, metadata.getObjEntity(), metadata.isRefreshingObjects(), metadata.isResolvingInherited());
    }

    ObjectResolver(DataContext context, ObjEntity entity, boolean refresh, boolean resolveInheritanceHierarchy) {
        this.init(context, entity, refresh, resolveInheritanceHierarchy);
    }

    void init(DataContext context, ObjEntity entity, boolean refresh, boolean resolveInheritanceHierarchy) {
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("ObjEntity '" + entity.getName() + "' has no DbEntity.");
        }
        if (dbEntity.getPrimaryKey().size() == 0) {
            throw new CayenneRuntimeException("Won't be able to create ObjectId for '" + entity.getName() + "'. Reason: DbEntity '" + dbEntity.getName() + "' has no Primary Key defined.");
        }
        this.context = context;
        this.refreshObjects = refresh;
        this.entity = entity;
        this.inheritanceTree = context.getEntityResolver().lookupInheritanceTree(entity);
        this.resolveInheritance = this.inheritanceTree != null ? resolveInheritanceHierarchy : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List synchronizedObjectsFromDataRows(List rows) {
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            DataRowStore dataRowStore = this.context.getObjectStore().getDataRowCache();
            synchronized (dataRowStore) {
                return this.objectsFromDataRows(rows);
            }
        }
    }

    List objectsFromDataRows(List rows) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList(1);
        }
        ArrayList<DataObject> results = new ArrayList<DataObject>(rows.size());
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            results.add(this.objectFromDataRow((DataRow)it.next()));
        }
        this.context.getObjectStore().snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }

    List relatedObjectsFromDataRows(List rows, PrefetchProcessorNode node) {
        if (rows == null || rows.size() == 0) {
            return new ArrayList(1);
        }
        ObjEntity sourceObjEntity = (ObjEntity)node.getIncoming().getSourceEntity();
        String relatedIdPrefix = node.getIncoming().getReverseDbRelationshipPath() + ".";
        ArrayList<DataObject> results = new ArrayList<DataObject>(rows.size());
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            DataRow row = (DataRow)it.next();
            DataObject object = this.objectFromDataRow(row);
            results.add(object);
            ObjectId id = row.createObjectId(sourceObjEntity.getName(), sourceObjEntity.getDbEntity(), relatedIdPrefix);
            DataObject parentObject = this.context.getObjectStore().getObject(id);
            if (parentObject == null || parentObject.getPersistenceState() == 5) continue;
            node.linkToParent(object, parentObject);
        }
        this.context.getObjectStore().snapshotsUpdatedForObjects(results, rows, this.refreshObjects);
        return results;
    }

    DataObject objectFromDataRow(DataRow row) {
        ObjEntity objectEntity = this.entity;
        if (this.resolveInheritance && (objectEntity = this.inheritanceTree.entityMatchingRow(row)) == null) {
            objectEntity = this.entity;
        }
        ObjectId anId = row.createObjectId(objectEntity);
        DataObject object = (DataObject)this.context.localObject(anId, null);
        int state = object.getPersistenceState();
        switch (state) {
            case 3: 
            case 4: 
            case 6: {
                if (!this.refreshObjects) break;
            }
            case 5: {
                DataRowUtils.mergeObjectWithSnapshot(objectEntity, object, row);
                object.setSnapshotVersion(row.getVersion());
            }
        }
        object.fetchFinished();
        return object;
    }

    ObjEntity getEntity() {
        return this.entity;
    }
}

