/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.Fault;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataContextDelegate;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataRowStore;
import org.objectstyle.cayenne.access.DataRowUtils;
import org.objectstyle.cayenne.access.ObjectDiff;
import org.objectstyle.cayenne.access.ObjectStoreGraphDiff;
import org.objectstyle.cayenne.access.QueryEngine;
import org.objectstyle.cayenne.access.event.SnapshotEvent;
import org.objectstyle.cayenne.access.event.SnapshotEventListener;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.graph.CompoundDiff;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.NodeCreateOperation;
import org.objectstyle.cayenne.graph.NodeDeleteOperation;
import org.objectstyle.cayenne.graph.NodeDiff;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.query.ObjectIdQuery;
import org.objectstyle.cayenne.validation.ValidationException;
import org.objectstyle.cayenne.validation.ValidationResult;

public class ObjectStore
implements Serializable,
SnapshotEventListener {
    private static Logger logObj = Logger.getLogger(ObjectStore.class);
    protected transient Map newObjectsMap;
    protected Map objectMap = new HashMap();
    protected Map queryResultMap = new HashMap();
    protected Map changes = new HashMap();
    int currentDiffId;
    protected transient DataRowStore dataRowCache;
    protected DataContext context;

    public ObjectStore() {
    }

    public ObjectStore(DataRowStore dataRowCache) {
        this.setDataRowCache(dataRowCache);
    }

    void recordObjectDeleted(Persistent object) {
        object.setPersistenceState(6);
        this.registerDiff(object, new NodeDeleteOperation(object.getObjectId()));
    }

    void recordObjectCreated(Persistent object) {
        this.registerDiff(object, new NodeCreateOperation(object.getObjectId()));
        this.recordObjectRegistered(object);
    }

    public void recordArcCreated(Persistent object, ObjectId targetId, String relationshipName) {
        this.registerDiff(object, new ObjectDiff.ArcOperation(object.getObjectId(), targetId, relationshipName, false));
    }

    public void recordArcDeleted(Persistent object, ObjectId targetId, String relationshipName) {
        this.registerDiff(object, new ObjectDiff.ArcOperation(object.getObjectId(), targetId, relationshipName, true));
    }

    synchronized ObjectDiff registerDiff(Persistent object, NodeDiff diff) {
        ObjectDiff objectDiff;
        ObjectId id = object.getObjectId();
        if (object.getPersistenceState() == 3) {
            object.setPersistenceState(4);
            if (object instanceof DataObject) {
                DataContextDelegate delegate;
                DataObject dataObject = (DataObject)object;
                DataRow snapshot = this.getCachedSnapshot(id);
                if (snapshot != null && snapshot.getVersion() != dataObject.getSnapshotVersion() && (delegate = dataObject.getDataContext().nonNullDelegate()).shouldMergeChanges(dataObject, snapshot)) {
                    ObjEntity entity = dataObject.getDataContext().getEntityResolver().lookupObjEntity(object);
                    DataRowUtils.forceMergeWithSnapshot(entity, dataObject, snapshot);
                    dataObject.setSnapshotVersion(snapshot.getVersion());
                    delegate.finishedMergeChanges(dataObject);
                }
            }
        }
        if (diff != null) {
            diff.setDiffId(++this.currentDiffId);
        }
        if ((objectDiff = (ObjectDiff)this.changes.get(id)) == null) {
            objectDiff = new ObjectDiff(this, object);
            objectDiff.setDiffId(++this.currentDiffId);
            this.changes.put(id, objectDiff);
        }
        if (diff != null) {
            objectDiff.addDiff(diff);
        }
        return objectDiff;
    }

    void recordObjectRegistered(Persistent object) {
        this.objectMap.put(object.getObjectId(), object);
        if (this.newObjectsMap != null) {
            this.newObjectsMap.put(object.getObjectId(), object);
        }
    }

    public int registeredObjectsCount() {
        return this.objectMap.size();
    }

    public int cachedQueriesCount() {
        return this.queryResultMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRowStore getDataRowCache() {
        if (this.dataRowCache == null && this.context != null) {
            ObjectStore objectStore = this;
            synchronized (objectStore) {
                DataDomain domain;
                if (this.dataRowCache == null && (domain = this.context.getParentDataDomain()) != null) {
                    this.setDataRowCache(domain.getSharedSnapshotCache());
                }
            }
        }
        return this.dataRowCache;
    }

    public void setDataRowCache(DataRowStore dataRowCache) {
        if (dataRowCache == this.dataRowCache) {
            return;
        }
        if (this.dataRowCache != null && dataRowCache.getEventManager() != null) {
            dataRowCache.getEventManager().removeListener(this, this.dataRowCache.getSnapshotEventSubject());
        }
        this.dataRowCache = dataRowCache;
        if (dataRowCache != null && dataRowCache.getEventManager() != null) {
            dataRowCache.getEventManager().addNonBlockingListener(this, "snapshotsChanged", SnapshotEvent.class, dataRowCache.getSnapshotEventSubject(), dataRowCache);
        }
    }

    public synchronized void objectsInvalidated(Collection objects) {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            if (object.getPersistenceState() == 2) continue;
            object.setPersistenceState(5);
            this.changes.remove(object.getObjectId());
            ids.add(object.getObjectId());
        }
        this.getDataRowCache().processSnapshotChanges(this, Collections.EMPTY_MAP, Collections.EMPTY_LIST, ids, Collections.EMPTY_LIST);
    }

    public synchronized void objectsUnregistered(Collection objects) {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            ObjectId id = object.getObjectId();
            this.objectMap.remove(id);
            this.changes.remove(id);
            ids.add(id);
            object.setDataContext(null);
            object.setObjectId(null);
            object.setPersistenceState(1);
        }
        this.getDataRowCache().processSnapshotChanges(this, Collections.EMPTY_MAP, Collections.EMPTY_LIST, ids, Collections.EMPTY_LIST);
    }

    public synchronized void objectsRolledBack() {
        Iterator it = this.getObjectIterator();
        while (it.hasNext()) {
            DataObject object = (DataObject)it.next();
            int objectState = object.getPersistenceState();
            switch (objectState) {
                case 2: {
                    it.remove();
                    object.setDataContext(null);
                    object.setObjectId(null);
                    object.setPersistenceState(1);
                    break;
                }
                case 4: 
                case 6: {
                    object.setPersistenceState(5);
                    break;
                }
            }
        }
        this.changes.clear();
    }

    public void objectRelationshipUnset(DataObject source, DataObject target, ObjRelationship relationship, boolean processFlattened) {
        ObjectId targetId = target != null ? target.getObjectId() : null;
        this.recordArcDeleted(source, targetId, relationship.getName());
    }

    public void objectRelationshipSet(DataObject source, DataObject target, ObjRelationship relationship, boolean processFlattened) {
        ObjectId targetId = target != null ? target.getObjectId() : null;
        this.recordArcCreated(source, targetId, relationship.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotsUpdatedForObjects(List objects, List snapshots, boolean refresh) {
        if (objects.size() != snapshots.size()) {
            throw new IllegalArgumentException("Counts of objects and corresponding snapshots do not match. Objects count: " + objects.size() + ", snapshots count: " + snapshots.size());
        }
        HashMap<ObjectId, DataRow> modified = null;
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                DataObject object = (DataObject)objects.get(i);
                if (object.getPersistenceState() == 5) continue;
                ObjectId oid = object.getObjectId();
                DataRow cachedSnapshot = this.getCachedSnapshot(oid);
                if (!refresh && cachedSnapshot != null) continue;
                DataRow newSnapshot = (DataRow)snapshots.get(i);
                if (cachedSnapshot != null) {
                    if (cachedSnapshot.equals(newSnapshot)) {
                        object.setSnapshotVersion(cachedSnapshot.getVersion());
                        continue;
                    }
                    newSnapshot.setReplacesVersion(cachedSnapshot.getVersion());
                }
                if (modified == null) {
                    modified = new HashMap<ObjectId, DataRow>();
                }
                modified.put(oid, newSnapshot);
            }
            if (modified != null) {
                this.getDataRowCache().processSnapshotChanges(this, modified, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            }
        }
    }

    public synchronized void objectsCommitted() {
        this.postprocessAfterCommit(new CompoundDiff());
    }

    ObjectStoreGraphDiff getChanges() {
        return new ObjectStoreGraphDiff(this);
    }

    Map getChangesByObjectId() {
        return this.changes;
    }

    void postprocessAfterPhantomCommit() {
        Iterator it = this.changes.keySet().iterator();
        while (it.hasNext()) {
            ObjectId id = (ObjectId)it.next();
            Persistent object = (Persistent)this.objectMap.get(id);
            object.setPersistenceState(3);
        }
        this.changes.clear();
    }

    void postprocessAfterCommit(GraphDiff parentChanges) {
        Iterator entries = this.objectMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            DataObject object = (DataObject)entry.getValue();
            switch (object.getPersistenceState()) {
                case 6: {
                    entries.remove();
                    object.setObjectContext(null);
                    object.setPersistenceState(1);
                    break;
                }
                case 2: 
                case 4: {
                    object.setPersistenceState(3);
                }
            }
        }
        if (!parentChanges.isNoop()) {
            parentChanges.apply(new IdUpdater());
        }
        this.changes.clear();
    }

    public synchronized void addObject(DataObject object) {
        this.recordObjectCreated(object);
    }

    public synchronized void startTrackingNewObjects() {
        this.newObjectsMap = new HashMap();
    }

    public synchronized void unregisterNewObjects() {
        if (this.newObjectsMap != null) {
            this.objectsUnregistered(this.newObjectsMap.values());
            this.newObjectsMap = null;
        }
    }

    public synchronized DataObject getObject(ObjectId id) {
        return (DataObject)this.objectMap.get(id);
    }

    public DataRow getCachedSnapshot(ObjectId oid) {
        if (this.context != null && this.context.getChannel() != null) {
            ObjectIdQuery query = new ObjectIdQuery(oid, true, 3);
            List results = this.context.getChannel().onQuery(this.context, query).firstList();
            return results.isEmpty() ? null : (DataRow)results.get(0);
        }
        return null;
    }

    public synchronized List getCachedQueryResult(String name) {
        return (List)this.queryResultMap.get(name);
    }

    public synchronized void cacheQueryResult(String name, List results) {
        this.queryResultMap.put(name, results);
    }

    public synchronized DataRow getSnapshot(ObjectId oid, QueryEngine engine) {
        return this.getDataRowCache().getSnapshot(oid, engine);
    }

    public synchronized DataRow getSnapshot(ObjectId oid) {
        if (this.context != null && this.context.getChannel() != null) {
            ObjectIdQuery query = new ObjectIdQuery(oid, true, 1);
            List results = this.context.getChannel().onQuery(this.context, query).firstList();
            return results.isEmpty() ? null : (DataRow)results.get(0);
        }
        return null;
    }

    public synchronized List getObjects() {
        return new ArrayList(this.objectMap.values());
    }

    public synchronized Iterator getObjectIterator() {
        return this.objectMap.values().iterator();
    }

    public EventManager getEventManager() {
        return this.getDataRowCache() != null ? this.getDataRowCache().getEventManager() : null;
    }

    public synchronized boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public synchronized List objectsInState(int state) {
        ArrayList<DataObject> filteredObjects = new ArrayList<DataObject>();
        Iterator it = this.objectMap.values().iterator();
        while (it.hasNext()) {
            DataObject nextObj = (DataObject)it.next();
            if (nextObj.getPersistenceState() != state) continue;
            filteredObjects.add(nextObj);
        }
        return filteredObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotsChanged(SnapshotEvent event) {
        if (event.getPostedBy() == this || event.getSource() != this.getDataRowCache()) {
            return;
        }
        if (logObj.isDebugEnabled()) {
            logObj.debug("Received: " + event);
        }
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            this.processUpdatedSnapshots(event.getModifiedDiffs());
            this.processDeletedIDs(event.getDeletedIds());
            this.processInvalidatedIDs(event.getInvalidatedIds());
            this.processIndirectlyModifiedIDs(event.getIndirectlyModifiedIds());
        }
    }

    public synchronized void validateUncommittedObjects() throws ValidationException {
        DataObject dataObject;
        Iterator it;
        ArrayList<DataObject> deleted = null;
        ArrayList<DataObject> inserted = null;
        ArrayList<DataObject> updated = null;
        Iterator allIt = this.getObjectIterator();
        while (allIt.hasNext()) {
            DataObject dataObject2 = (DataObject)allIt.next();
            switch (dataObject2.getPersistenceState()) {
                case 2: {
                    if (inserted == null) {
                        inserted = new ArrayList<DataObject>();
                    }
                    inserted.add(dataObject2);
                    break;
                }
                case 4: {
                    if (updated == null) {
                        updated = new ArrayList<DataObject>();
                    }
                    updated.add(dataObject2);
                    break;
                }
                case 6: {
                    if (deleted == null) {
                        deleted = new ArrayList<DataObject>();
                    }
                    deleted.add(dataObject2);
                }
            }
        }
        ValidationResult validationResult = new ValidationResult();
        if (deleted != null) {
            it = deleted.iterator();
            while (it.hasNext()) {
                dataObject = (DataObject)it.next();
                dataObject.validateForDelete(validationResult);
            }
        }
        if (inserted != null) {
            it = inserted.iterator();
            while (it.hasNext()) {
                dataObject = (DataObject)it.next();
                dataObject.validateForInsert(validationResult);
            }
        }
        if (updated != null) {
            it = updated.iterator();
            while (it.hasNext()) {
                dataObject = (DataObject)it.next();
                dataObject.validateForUpdate(validationResult);
            }
        }
        if (validationResult.hasFailures()) {
            throw new ValidationException(validationResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveHollow(DataObject object) {
        if (object.getPersistenceState() != 5) {
            return;
        }
        DataContext context = object.getDataContext();
        if (context == null) {
            object.setPersistenceState(1);
            return;
        }
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            ObjectIdQuery query = new ObjectIdQuery(object.getObjectId(), false, 1);
            List results = context.getChannel().onQuery(context, query).firstList();
            if (results.size() == 0) {
                this.processDeletedIDs(Collections.singletonList(object.getObjectId()));
            } else if (object.getPersistenceState() == 5) {
                query = new ObjectIdQuery(object.getObjectId(), false, 2);
                results = context.getChannel().onQuery(context, query).firstList();
                if (results.size() == 0) {
                    this.processDeletedIDs(Collections.singletonList(object.getObjectId()));
                }
            }
        }
    }

    void processDeletedIDs(Collection deletedIDs) {
        if (deletedIDs != null && !deletedIDs.isEmpty()) {
            Iterator it = deletedIDs.iterator();
            while (it.hasNext()) {
                ObjectId oid = (ObjectId)it.next();
                DataObject object = this.getObject(oid);
                if (object == null) continue;
                switch (object.getPersistenceState()) {
                    case 3: 
                    case 5: 
                    case 6: {
                        DataContextDelegate delegate = object.getDataContext().nonNullDelegate();
                        if (!delegate.shouldProcessDelete(object)) break;
                        this.objectMap.remove(oid);
                        this.changes.remove(oid);
                        object.setDataContext(null);
                        delegate.finishedProcessDelete(object);
                        break;
                    }
                    case 4: {
                        DataContextDelegate delegate = object.getDataContext().nonNullDelegate();
                        if (!delegate.shouldProcessDelete(object)) break;
                        object.setPersistenceState(2);
                        this.changes.remove(oid);
                        this.recordObjectCreated(object);
                        delegate.finishedProcessDelete(object);
                    }
                }
            }
        }
    }

    void processInvalidatedIDs(Collection invalidatedIDs) {
        if (invalidatedIDs != null && !invalidatedIDs.isEmpty()) {
            Iterator it = invalidatedIDs.iterator();
            while (it.hasNext()) {
                ObjectId oid = (ObjectId)it.next();
                DataObject object = this.getObject(oid);
                if (object == null) continue;
                switch (object.getPersistenceState()) {
                    case 3: {
                        object.setPersistenceState(5);
                        break;
                    }
                    case 4: {
                        DataContext context = object.getDataContext();
                        DataRow diff = this.getSnapshot(oid);
                        DataContextDelegate delegate = context.nonNullDelegate();
                        if (delegate.shouldMergeChanges(object, diff)) {
                            ObjEntity entity = context.getEntityResolver().lookupObjEntity(object);
                            DataRowUtils.forceMergeWithSnapshot(entity, object, diff);
                            delegate.finishedMergeChanges(object);
                        }
                    }
                    case 5: {
                        break;
                    }
                }
            }
        }
    }

    void processIndirectlyModifiedIDs(Collection indirectlyModifiedIDs) {
        Iterator indirectlyModifiedIt = indirectlyModifiedIDs.iterator();
        while (indirectlyModifiedIt.hasNext()) {
            DataContextDelegate delegate;
            ObjectId oid = (ObjectId)indirectlyModifiedIt.next();
            DataObject object = this.getObject(oid);
            if (object == null || object.getPersistenceState() != 3 || !(delegate = object.getDataContext().nonNullDelegate()).shouldMergeChanges(object, null)) continue;
            ObjEntity entity = object.getDataContext().getEntityResolver().lookupObjEntity(object);
            Iterator relationshipIterator = entity.getRelationships().iterator();
            while (relationshipIterator.hasNext()) {
                ObjRelationship relationship = (ObjRelationship)relationshipIterator.next();
                if (!relationship.isSourceIndependentFromTargetChange()) continue;
                Fault fault = relationship.isToMany() ? Fault.getToManyFault() : Fault.getToOneFault();
                object.writePropertyDirectly(relationship.getName(), fault);
            }
            delegate.finishedProcessDelete(object);
        }
    }

    void processUpdatedSnapshots(Map diffs) {
        if (diffs != null && !diffs.isEmpty()) {
            Iterator oids = diffs.entrySet().iterator();
            while (oids.hasNext()) {
                ObjEntity entity;
                DataContextDelegate delegate;
                Map.Entry entry = oids.next();
                ObjectId oid = (ObjectId)entry.getKey();
                DataObject object = this.getObject(oid);
                if (object == null || object.getPersistenceState() == 5) continue;
                DataRow diff = (DataRow)entry.getValue();
                if (object.getPersistenceState() == 3) {
                    delegate = object.getDataContext().nonNullDelegate();
                    if (!delegate.shouldMergeChanges(object, diff)) continue;
                    entity = object.getDataContext().getEntityResolver().lookupObjEntity(object);
                    DataRow snapshot = this.getSnapshot(object.getObjectId());
                    DataRowUtils.refreshObjectWithSnapshot(entity, object, snapshot, true);
                    delegate.finishedMergeChanges(object);
                    continue;
                }
                if (object.getPersistenceState() != 6 && object.getPersistenceState() != 4 || !(delegate = object.getDataContext().nonNullDelegate()).shouldMergeChanges(object, diff)) continue;
                entity = object.getDataContext().getEntityResolver().lookupObjEntity(object);
                DataRowUtils.forceMergeWithSnapshot(entity, object, diff);
                delegate.finishedMergeChanges(object);
            }
        }
    }

    public DataContext getContext() {
        return this.context;
    }

    public void setContext(DataContext context) {
        this.context = context;
    }

    class IdUpdater
    implements GraphChangeHandler {
        IdUpdater() {
        }

        public void nodeIdChanged(Object nodeId, Object newId) {
            Persistent object = (Persistent)ObjectStore.this.objectMap.remove(nodeId);
            if (object != null) {
                object.setObjectId((ObjectId)newId);
                ObjectStore.this.objectMap.put(newId, object);
            }
        }

        public void nodeCreated(Object nodeId) {
        }

        public void nodeRemoved(Object nodeId) {
        }

        public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        }

        public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        }

        public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        }
    }
}

