/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.ObjectDiff;
import org.objectstyle.cayenne.access.ObjectStore;
import org.objectstyle.cayenne.graph.CompoundDiff;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.validation.ValidationException;
import org.objectstyle.cayenne.validation.ValidationResult;

class ObjectStoreGraphDiff
implements GraphDiff {
    private ObjectStore objectStore;
    private GraphDiff resolvedDiff;

    ObjectStoreGraphDiff(ObjectStore objectStore) {
        this.objectStore = objectStore;
        this.preprocess(objectStore);
    }

    Map getChangesByObjectId() {
        return this.objectStore.getChangesByObjectId();
    }

    void clearChanges() {
    }

    boolean validateAndCheckNoop() {
        if (this.getChangesByObjectId().isEmpty()) {
            return true;
        }
        ValidationResult result = new ValidationResult();
        boolean noop = true;
        Iterator it = this.getChangesByObjectId().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (((ObjectDiff)entry.getValue()).isNoop()) continue;
            noop = false;
            DataObject object = this.objectStore.getObject((ObjectId)entry.getKey());
            switch (object.getPersistenceState()) {
                case 2: {
                    object.validateForInsert(result);
                    break;
                }
                case 4: {
                    object.validateForUpdate(result);
                    break;
                }
                case 6: {
                    object.validateForDelete(result);
                }
            }
        }
        if (result.hasFailures()) {
            throw new ValidationException(result);
        }
        return noop;
    }

    public boolean isNoop() {
        if (this.getChangesByObjectId().isEmpty()) {
            return true;
        }
        Iterator it = this.getChangesByObjectId().values().iterator();
        while (it.hasNext()) {
            if (((ObjectDiff)it.next()).isNoop()) continue;
            return false;
        }
        return true;
    }

    public void apply(GraphChangeHandler handler) {
        this.resolveDiff();
        this.resolvedDiff.apply(handler);
    }

    public void undo(GraphChangeHandler handler) {
        this.resolveDiff();
        this.resolvedDiff.undo(handler);
    }

    private void resolveDiff() {
        if (this.resolvedDiff == null) {
            CompoundDiff diff = new CompoundDiff();
            Map changes = this.getChangesByObjectId();
            if (!changes.isEmpty()) {
                ArrayList allChanges = new ArrayList(changes.size() * 2);
                Iterator it = changes.values().iterator();
                while (it.hasNext()) {
                    ((ObjectDiff)it.next()).appendDiffs(allChanges);
                }
                Collections.sort(allChanges);
                diff.addAll(allChanges);
            }
            this.resolvedDiff = diff;
        }
    }

    private void preprocess(ObjectStore objectStore) {
        Map changes = this.getChangesByObjectId();
        if (!changes.isEmpty()) {
            Iterator it = changes.entrySet().iterator();
            while (it.hasNext()) {
                DataObject object;
                ObjectId objectId;
                Map.Entry entry = it.next();
                ObjectId id = (ObjectId)entry.getKey();
                if (id.equals(objectId = (object = objectStore.getObject(id)).getObjectId())) continue;
                if (objectId != null) {
                    Map replacement = id.getReplacementIdMap();
                    replacement.clear();
                    replacement.putAll(objectId.getIdSnapshot());
                }
                object.setObjectId(id);
            }
        }
    }
}

