/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.access.util.DefaultOperationObserver;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.util.Util;

public class QueryResult
extends DefaultOperationObserver {
    protected Map queries = new LinkedHashMap();

    public void clear() {
        this.queries.clear();
    }

    public Iterator getQueries() {
        return this.queries.keySet().iterator();
    }

    public List getResults(Query query) {
        List list = (List)this.queries.get(query);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public int getFirstUpdateCount(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size > 0) {
            Iterator it = allResults.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (!(object instanceof int[])) continue;
                int[] counts = (int[])object;
                return counts.length > 0 ? counts[0] : -1;
            }
        }
        return -1;
    }

    public int[] getFirstUpdateCounts(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size > 0) {
            Iterator it = allResults.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (object instanceof Number) {
                    return new int[]{((Number)object).intValue()};
                }
                if (!(object instanceof int[])) continue;
                return (int[])object;
            }
        }
        return new int[0];
    }

    public List getFirstRows(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        Iterator it = allResults.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof List)) continue;
            return (List)obj;
        }
        return Collections.EMPTY_LIST;
    }

    public List getRows(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList(size);
        Iterator it = allResults.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof List)) continue;
            list.add(obj);
        }
        return list;
    }

    public List getUpdates(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList(size);
        Iterator it = allResults.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Number) {
                list.add(object);
                continue;
            }
            if (!(object instanceof int[])) continue;
            int[] ints = (int[])object;
            for (int i = 0; i < ints.length; ++i) {
                list.add(new Integer(ints[i]));
            }
        }
        return list;
    }

    public void nextQueryException(Query query, Exception ex) {
        super.nextQueryException(query, ex);
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex));
    }

    public void nextGlobalException(Exception ex) {
        super.nextGlobalException(ex);
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(ex));
    }

    public boolean isIteratedResult() {
        return false;
    }

    public void nextBatchCount(Query query, int[] resultCount) {
        ArrayList<int[]> list = (ArrayList<int[]>)this.queries.get(query);
        if (list == null) {
            list = new ArrayList<int[]>(5);
            this.queries.put(query, list);
        }
        list.add(resultCount);
    }

    public void nextCount(Query query, int resultCount) {
        super.nextCount(query, resultCount);
        ArrayList<Integer> list = (ArrayList<Integer>)this.queries.get(query);
        if (list == null) {
            list = new ArrayList<Integer>(5);
            this.queries.put(query, list);
        }
        list.add(new Integer(resultCount));
    }

    public void nextDataRows(Query query, List dataRows) {
        super.nextDataRows(query, dataRows);
        ArrayList<List> list = (ArrayList<List>)this.queries.get(query);
        if (list == null) {
            list = new ArrayList<List>(5);
            this.queries.put(query, list);
        }
        list.add(dataRows);
    }

    public void nextDataRows(Query q, ResultIterator it) {
        throw new CayenneRuntimeException("Iterated results are not supported by " + this.getClass().getName());
    }
}

