/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.OptimisticLockException;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.jdbc.BaseSQLAction;
import org.objectstyle.cayenne.access.jdbc.JDBCResultIterator;
import org.objectstyle.cayenne.access.jdbc.RowDescriptor;
import org.objectstyle.cayenne.access.trans.BatchQueryBuilder;
import org.objectstyle.cayenne.access.trans.DeleteBatchQueryBuilder;
import org.objectstyle.cayenne.access.trans.InsertBatchQueryBuilder;
import org.objectstyle.cayenne.access.trans.UpdateBatchQueryBuilder;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.DeleteBatchQuery;
import org.objectstyle.cayenne.query.InsertBatchQuery;
import org.objectstyle.cayenne.query.UpdateBatchQuery;

public class BatchAction
extends BaseSQLAction {
    protected boolean batch;
    protected BatchQuery query;

    public BatchAction(BatchQuery batchQuery, DbAdapter adapter, EntityResolver entityResolver) {
        super(adapter, entityResolver);
        this.query = batchQuery;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean runningAsBatch) {
        this.batch = runningAsBatch;
    }

    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        BatchQueryBuilder queryBuilder = this.createBuilder();
        boolean generatesKeys = this.hasGeneratedKeys();
        if (this.batch && !generatesKeys) {
            this.runAsBatch(connection, queryBuilder, observer);
        } else {
            this.runAsIndividualQueries(connection, queryBuilder, observer, generatesKeys);
        }
    }

    protected BatchQueryBuilder createBuilder() throws CayenneException {
        if (this.query instanceof InsertBatchQuery) {
            return new InsertBatchQueryBuilder(this.getAdapter());
        }
        if (this.query instanceof UpdateBatchQuery) {
            return new UpdateBatchQueryBuilder(this.getAdapter());
        }
        if (this.query instanceof DeleteBatchQuery) {
            return new DeleteBatchQueryBuilder(this.getAdapter());
        }
        throw new CayenneException("Unsupported batch query: " + this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsBatch(Connection con, BatchQueryBuilder queryBuilder, OperationObserver delegate) throws SQLException, Exception {
        String queryStr = queryBuilder.createSqlString(this.query);
        boolean isLoggable = QueryLogger.isLoggable();
        QueryLogger.logQuery(queryStr, Collections.EMPTY_LIST);
        this.query.reset();
        PreparedStatement statement = con.prepareStatement(queryStr);
        try {
            while (this.query.next()) {
                if (isLoggable) {
                    QueryLogger.logQueryParameters("batch bind", queryBuilder.getParameterValues(this.query));
                }
                queryBuilder.bindParameters(statement, this.query);
                statement.addBatch();
            }
            int[] results = statement.executeBatch();
            delegate.nextBatchCount(this.query, results);
            if (isLoggable) {
                int totalUpdateCount = 0;
                for (int i = 0; i < results.length; ++i) {
                    totalUpdateCount += results[i];
                }
                QueryLogger.logUpdateCount(totalUpdateCount);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAsIndividualQueries(Connection connection, BatchQueryBuilder queryBuilder, OperationObserver delegate, boolean generatesKeys) throws SQLException, Exception {
        boolean isLoggable = QueryLogger.isLoggable();
        boolean useOptimisticLock = this.query.isUsingOptimisticLocking();
        String queryStr = queryBuilder.createSqlString(this.query);
        QueryLogger.logQuery(queryStr, Collections.EMPTY_LIST);
        this.query.reset();
        PreparedStatement statement = generatesKeys ? connection.prepareStatement(queryStr, 1) : connection.prepareStatement(queryStr);
        try {
            while (this.query.next()) {
                if (isLoggable) {
                    QueryLogger.logQueryParameters("bind", queryBuilder.getParameterValues(this.query));
                }
                queryBuilder.bindParameters(statement, this.query);
                int updated = statement.executeUpdate();
                if (useOptimisticLock && updated != 1) {
                    Map snapshot = Collections.EMPTY_MAP;
                    if (this.query instanceof UpdateBatchQuery) {
                        snapshot = ((UpdateBatchQuery)this.query).getCurrentQualifier();
                    } else if (this.query instanceof DeleteBatchQuery) {
                        snapshot = ((DeleteBatchQuery)this.query).getCurrentQualifier();
                    }
                    throw new OptimisticLockException(this.query.getDbEntity(), queryStr, snapshot);
                }
                delegate.nextCount(this.query, updated);
                if (generatesKeys) {
                    this.processGeneratedKeys(statement, delegate);
                }
                if (!isLoggable) continue;
                QueryLogger.logUpdateCount(updated);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    protected boolean hasGeneratedKeys() {
        if (!this.adapter.supportsGeneratedKeys()) {
            return false;
        }
        if (this.query instanceof InsertBatchQuery) {
            Iterator attributes = this.query.getDbEntity().getGeneratedAttributes().iterator();
            while (attributes.hasNext()) {
                if (!((DbAttribute)attributes.next()).isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    protected void processGeneratedKeys(Statement statement, OperationObserver observer) throws SQLException, CayenneException {
        ResultSet keysRS = statement.getGeneratedKeys();
        RowDescriptor descriptor = new RowDescriptor(keysRS, this.getAdapter().getExtendedTypes());
        JDBCResultIterator iterator = new JDBCResultIterator(null, null, keysRS, descriptor, 0);
        observer.nextGeneratedDataRows(this.query, iterator);
    }
}

