/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.jdbc;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ProcedureParameter;

public class ColumnDescriptor
implements Serializable {
    protected String tableName;
    protected String procedureName;
    protected String name;
    protected String qualifiedColumnName;
    protected String label;
    protected boolean primaryKey;
    protected int jdbcType;
    protected String javaClass;

    public ColumnDescriptor() {
    }

    public ColumnDescriptor(String columnName, int jdbcType, String javaClass) {
        this.name = columnName;
        this.qualifiedColumnName = columnName;
        this.label = columnName;
        this.jdbcType = jdbcType;
        this.javaClass = javaClass;
    }

    public ColumnDescriptor(ObjAttribute objAttribute, DbAttribute dbAttribute) {
        this(objAttribute, dbAttribute, null);
    }

    public ColumnDescriptor(DbAttribute attribute, String columnAlias) {
        this.name = attribute.getName();
        this.qualifiedColumnName = attribute.getAliasedName(columnAlias);
        this.label = this.name;
        this.jdbcType = attribute.getType();
        this.primaryKey = attribute.isPrimaryKey();
        this.javaClass = this.getDefaultJavaClass(attribute.getMaxLength(), attribute.getPrecision());
        if (attribute.getEntity() != null) {
            this.tableName = attribute.getEntity().getName();
        }
    }

    public ColumnDescriptor(ObjAttribute objAttribute, DbAttribute dbAttribute, String columnAlias) {
        this(dbAttribute, columnAlias);
        this.label = objAttribute.getDbAttributePath();
        this.javaClass = objAttribute.getType();
    }

    public ColumnDescriptor(ProcedureParameter parameter) {
        this.qualifiedColumnName = this.name = parameter.getName();
        this.label = this.name;
        this.jdbcType = parameter.getType();
        this.javaClass = this.getDefaultJavaClass(parameter.getMaxLength(), parameter.getPrecision());
        if (parameter.getProcedure() != null) {
            this.procedureName = parameter.getProcedure().getName();
        }
    }

    public ColumnDescriptor(ResultSetMetaData metaData, int position) throws SQLException {
        String name = metaData.getColumnLabel(position);
        if (!(name != null && name.length() != 0 || (name = metaData.getColumnName(position)) != null && name.length() != 0)) {
            name = "column_" + position;
        }
        this.name = name;
        this.qualifiedColumnName = name;
        this.label = name;
        this.jdbcType = metaData.getColumnType(position);
        this.javaClass = this.getDefaultJavaClass(metaData.getColumnDisplaySize(position), metaData.getScale(position));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ColumnDescriptor)) {
            return false;
        }
        ColumnDescriptor rhs = (ColumnDescriptor)o;
        return new EqualsBuilder().append(this.name, rhs.name).append(this.qualifiedColumnName, rhs.qualifiedColumnName).append(this.procedureName, rhs.procedureName).append(this.label, rhs.label).append(this.tableName, rhs.tableName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 43).append(this.name).append(this.qualifiedColumnName).append(this.procedureName).append(this.tableName).append(this.label).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("namePrefix", this.getQualifiedColumnName());
        builder.append("name", this.getName());
        builder.append("label", this.getLabel());
        builder.append("tableName", this.getTableName());
        builder.append("procedureName", this.getProcedureName());
        builder.append("javaClass", this.getJavaClass());
        builder.append("jdbcType", this.getJdbcType());
        return builder.toString();
    }

    public String getDefaultJavaClass(int size, int scale) {
        return TypesMapping.getJavaBySqlType(this.getJdbcType(), size, scale);
    }

    public String getQualifiedColumnName() {
        return this.qualifiedColumnName != null ? this.qualifiedColumnName : this.name;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getName() {
        return this.name;
    }

    public void setJdbcType(int i) {
        this.jdbcType = i;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setPrimaryKey(boolean b) {
        this.primaryKey = b;
    }

    public void setJavaClass(String string) {
        this.javaClass = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public void setQualifiedColumnName(String namePrefix) {
        this.qualifiedColumnName = namePrefix;
    }

    public String getLabel() {
        return this.label != null ? this.label : this.getName();
    }

    public void setLabel(String columnName) {
        this.label = columnName;
    }
}

