/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.access.trans.BatchQueryBuilder;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.query.BatchQuery;

public class InsertBatchQueryBuilder
extends BatchQueryBuilder {
    public InsertBatchQueryBuilder(DbAdapter adapter) {
        super.setAdapter(adapter);
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        List dbAttributes = query.getDbAttributes();
        int attributeCount = dbAttributes.size();
        int j = 0;
        for (int i = 0; i < attributeCount; ++i) {
            DbAttribute attribute = (DbAttribute)dbAttributes.get(i);
            if (!this.includeInBatch(attribute)) continue;
            Object value = query.getValue(i);
            this.adapter.bindParameter(statement, value, ++j, attribute.getType(), attribute.getPrecision());
        }
    }

    public List getParameterValues(BatchQuery query) {
        List attributes = query.getDbAttributes();
        int len = attributes.size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = (DbAttribute)attributes.get(i);
            if (!this.includeInBatch(attribute)) continue;
            values.add(query.getValue(i));
        }
        return values;
    }

    public String createSqlString(BatchQuery batch) {
        String table = batch.getDbEntity().getFullyQualifiedName();
        List dbAttributes = batch.getDbAttributes();
        StringBuffer query = new StringBuffer("INSERT INTO ");
        query.append(table).append(" (");
        int columnCount = 0;
        Iterator it = dbAttributes.iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            if (!this.includeInBatch(attribute)) continue;
            if (columnCount > 0) {
                query.append(", ");
            }
            query.append(attribute.getName());
            ++columnCount;
        }
        query.append(") VALUES (");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                query.append(", ");
            }
            query.append('?');
        }
        query.append(')');
        return query.toString();
    }

    protected boolean includeInBatch(DbAttribute attribute) {
        return !attribute.isGenerated() || attribute.isPrimaryKey() && !this.adapter.supportsGeneratedKeys();
    }
}

