/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.query.UpdateQuery;

public class UpdateTranslator
extends QueryAssembler {
    public String aliasForTable(DbEntity dbEnt) {
        throw new RuntimeException("aliases not supported");
    }

    public void dbRelationshipAdded(DbRelationship dbRel) {
        throw new RuntimeException("db relationships not supported");
    }

    public String createSqlString() throws Exception {
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("UPDATE ");
        DbEntity dbEnt = this.getRootEntity().getDbEntity();
        queryBuf.append(dbEnt.getFullyQualifiedName());
        this.buildSetClause(queryBuf, (UpdateQuery)this.query);
        String qualifierStr = this.adapter.getQualifierTranslator(this).doTranslation();
        if (qualifierStr != null) {
            queryBuf.append(" WHERE ").append(qualifierStr);
        }
        return queryBuf.toString();
    }

    private void buildSetClause(StringBuffer queryBuf, UpdateQuery query) {
        Map updAttrs = query.getUpdAttributes();
        Iterator attrIt = updAttrs.entrySet().iterator();
        if (!attrIt.hasNext()) {
            throw new CayenneRuntimeException("Nothing to update.");
        }
        DbEntity dbEnt = this.getRootEntity().getDbEntity();
        queryBuf.append(" SET ");
        boolean appendedSomething = false;
        while (attrIt.hasNext()) {
            Map.Entry entry = attrIt.next();
            String nextKey = (String)entry.getKey();
            Object attrVal = entry.getValue();
            if (appendedSomething) {
                queryBuf.append(", ");
            }
            queryBuf.append(nextKey).append(" = ?");
            super.addToParamList((DbAttribute)dbEnt.getAttribute(nextKey), attrVal);
            appendedSomething = true;
        }
    }
}

