/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.util.DefaultOperationObserver;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.util.Util;

public class SelectObserver
extends DefaultOperationObserver {
    protected Map results = new HashMap();
    protected int selectCount;

    public SelectObserver() {
    }

    public SelectObserver(Level logLevel) {
        super.setLoggingLevel(logLevel);
    }

    public int getSelectCount() {
        return this.selectCount;
    }

    public List getResults(Query q) {
        return (List)this.results.get(q);
    }

    public Map getResults() {
        return this.results;
    }

    public void clear() {
        this.selectCount = 0;
        this.results.clear();
    }

    public void nextDataRows(Query query, List dataRows) {
        if (dataRows != null) {
            this.results.put(query, dataRows);
        }
        ++this.selectCount;
    }

    public List getResultsAsObjects(DataContext dataContext, Query rootQuery) {
        QueryMetadata info = rootQuery.getMetaData(dataContext.getEntityResolver());
        return dataContext.objectsFromDataRows(info.getObjEntity(), this.getResults(rootQuery), info.isRefreshingObjects(), info.isResolvingInherited());
    }

    public void nextQueryException(Query query, Exception ex) {
        super.nextQueryException(query, ex);
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex));
    }

    public void nextGlobalException(Exception ex) {
        super.nextGlobalException(ex);
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(ex));
    }
}

