/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import java.io.PrintWriter;
import java.util.Iterator;
import org.objectstyle.cayenne.conf.ConfigSaverDelegate;
import org.objectstyle.cayenne.conn.DataSourceInfo;
import org.objectstyle.cayenne.util.Util;

public class ConfigSaver {
    protected ConfigSaverDelegate delegate;

    public ConfigSaver() {
    }

    public ConfigSaver(ConfigSaverDelegate delegate) {
        this.delegate = delegate;
    }

    public void storeDomains(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        pw.println("<domains project-version=\"" + this.delegate.projectVersion() + "\">");
        Iterator it = this.delegate.domainNames();
        while (it.hasNext()) {
            this.storeDomain(pw, (String)it.next());
        }
        Iterator views = this.delegate.viewNames();
        while (views.hasNext()) {
            this.storeDataView(pw, (String)views.next());
        }
        pw.println("</domains>");
    }

    protected void storeDataView(PrintWriter pw, String dataViewName) {
        String location = this.delegate.viewLocation(dataViewName);
        pw.print("<view name=\"" + dataViewName.trim());
        pw.print("\" location=\"" + location.trim());
        pw.println("\"/>");
    }

    protected void storeDomain(PrintWriter pw, String domainName) {
        pw.println("<domain name=\"" + domainName.trim() + "\">");
        Iterator properties = this.delegate.propertyNames(domainName);
        boolean breakNeeded = properties.hasNext();
        while (properties.hasNext()) {
            String value;
            String name = (String)properties.next();
            if (name == null || (value = this.delegate.propertyValue(domainName, name)) == null) continue;
            pw.print("\t<property name=\"" + Util.encodeXmlAttribute(name.trim()));
            pw.println("\" value=\"" + Util.encodeXmlAttribute(value.trim()) + "\"/>");
        }
        Iterator maps = this.delegate.mapNames(domainName);
        if (maps.hasNext()) {
            if (breakNeeded) {
                pw.println();
            }
            breakNeeded = true;
        }
        while (maps.hasNext()) {
            String mapName = (String)maps.next();
            String mapLocation = this.delegate.mapLocation(domainName, mapName);
            pw.print("\t<map name=\"" + mapName.trim());
            pw.print("\" location=\"" + mapLocation.trim());
            pw.println("\"/>");
        }
        Iterator nodes = this.delegate.nodeNames(domainName);
        if (nodes.hasNext() && breakNeeded) {
            pw.println();
        }
        while (nodes.hasNext()) {
            String nodeName = (String)nodes.next();
            String datasource = this.delegate.nodeDataSourceName(domainName, nodeName);
            String adapter = this.delegate.nodeAdapterName(domainName, nodeName);
            String factory = this.delegate.nodeFactoryName(domainName, nodeName);
            Iterator mapNames = this.delegate.linkedMapNames(domainName, nodeName);
            pw.println("\t<node name=\"" + nodeName.trim() + "\"");
            if (datasource != null) {
                datasource = datasource.trim();
                pw.print("\t\t datasource=\"" + datasource + "\"");
            }
            pw.println("");
            if (adapter != null) {
                pw.println("\t\t adapter=\"" + adapter + "\"");
            }
            if (factory != null) {
                pw.print("\t\t factory=\"" + factory.trim() + "\"");
            }
            pw.println(">");
            while (mapNames.hasNext()) {
                String mapName = (String)mapNames.next();
                pw.println("\t\t\t<map-ref name=\"" + mapName.trim() + "\"/>");
            }
            pw.println("\t </node>");
        }
        pw.println("</domain>");
    }

    public void storeDataNode(PrintWriter out, DataSourceInfo info) {
        String encoded;
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.print("<driver project-version=\"1.1\"");
        if (info.getJdbcDriver() != null) {
            out.print(" class=\"" + info.getJdbcDriver() + "\"");
        }
        out.println(">");
        if (info.getDataSourceUrl() != null) {
            encoded = Util.encodeXmlAttribute(info.getDataSourceUrl());
            out.println("\t<url value=\"" + encoded + "\"/>");
        }
        out.println("\t<connectionPool min=\"" + info.getMinConnections() + "\" max=\"" + info.getMaxConnections() + "\" />");
        if (info.getUserName() != null || info.getPassword() != null) {
            out.print("\t<login");
            if (info.getUserName() != null) {
                encoded = Util.encodeXmlAttribute(info.getUserName());
                out.print(" userName=\"" + encoded + "\"");
            }
            if (info.getPassword() != null) {
                encoded = Util.encodeXmlAttribute(info.getPassword());
                out.print(" password=\"" + encoded + "\"");
            }
            out.println("/>");
        }
        out.println("</driver>");
    }
}

