/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.ConfigurationException;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.conf.DataSourceFactory;

public class DBCPDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = Logger.getLogger(DBCPDataSourceFactory.class);
    private static final String SUFFIX = ".properties";
    public static final String PROPERTY_PREFIX = "cayenne.dbcp.";
    public static final String PS_PROPERTY_PREFIX = "cayenne.dbcp.ps.";
    protected Configuration parentConfiguration;

    public void initializeWithParentConfiguration(Configuration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public DataSource getDataSource(String location, Level logLevel) throws Exception {
        return this.getDataSource(location);
    }

    public DataSource getDataSource(String location) throws Exception {
        if (!location.endsWith(SUFFIX)) {
            location = location.concat(SUFFIX);
        }
        logger.info("Loading DBCP properties from " + location);
        Properties properties = this.loadProperties(location);
        logger.info("Loaded DBCP properties: " + properties);
        this.loadDriverClass(properties);
        ConnectionFactory factory = this.createConnectionFactory(properties);
        KeyedObjectPoolFactory statementPool = this.createStatementPool(properties);
        GenericObjectPool.Config config = this.createPoolConfig(properties);
        String validationQuery = this.stringProperty(properties, "validationQuery");
        boolean defaultReadOnly = this.booleanProperty(properties, "defaultReadOnly", false);
        boolean defaultAutoCommit = this.booleanProperty(properties, "defaultAutoCommit", false);
        int defaultTransactionIsolation = this.defaultTransactionIsolation(properties, "defaultTransactionIsolation", 8);
        String defaultCatalog = this.stringProperty(properties, "defaultCatalog");
        GenericObjectPool connectionPool = new GenericObjectPool(null, config);
        new PoolableConnectionFactory(factory, (ObjectPool)connectionPool, statementPool, validationQuery, defaultReadOnly ? Boolean.TRUE : Boolean.FALSE, defaultAutoCommit, defaultTransactionIsolation, defaultCatalog, null);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        dataSource.setAccessToUnderlyingConnectionAllowed(this.booleanProperty(properties, "accessToUnderlyingConnectionAllowed", false));
        return dataSource;
    }

    void loadDriverClass(Properties properties) throws Exception {
        String driver = this.stringProperty(properties, "driverClassName");
        logger.info("loading JDBC driver class: " + driver);
        if (driver == null) {
            throw new NullPointerException("No value for required property: cayenne.dbcp.driverClassName");
        }
        Class.forName(driver);
    }

    KeyedObjectPoolFactory createStatementPool(Properties properties) throws Exception {
        if (!this.booleanProperty(properties, "poolPreparedStatements", false)) {
            return null;
        }
        int maxActive = this.intProperty(properties, "ps.maxActive", 8);
        byte whenExhaustedAction = this.whenExhaustedAction(properties, "ps.whenExhaustedAction", (byte)1);
        long maxWait = this.longProperty(properties, "ps.maxWait", -1L);
        int maxIdle = this.intProperty(properties, "ps.maxIdle", 8);
        int maxTotal = this.intProperty(properties, "ps.maxTotal", 1);
        boolean testOnBorrow = this.booleanProperty(properties, "ps.testOnBorrow", false);
        boolean testOnReturn = this.booleanProperty(properties, "ps.testOnReturn", false);
        long timeBetweenEvictionRunsMillis = this.longProperty(properties, "ps.timeBetweenEvictionRunsMillis", -1L);
        int numTestsPerEvictionRun = this.intProperty(properties, "ps.numTestsPerEvictionRun", 3);
        long minEvictableIdleTimeMillis = this.longProperty(properties, "ps.minEvictableIdleTimeMillis", 1800000L);
        boolean testWhileIdle = this.booleanProperty(properties, "ps.testWhileIdle", false);
        return new GenericKeyedObjectPoolFactory(null, maxActive, whenExhaustedAction, maxWait, maxIdle, maxTotal, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    ConnectionFactory createConnectionFactory(Properties properties) {
        String url = this.stringProperty(properties, "url");
        String userName = this.stringProperty(properties, "username");
        String password = this.stringProperty(properties, "password");
        if (url == null) {
            throw new NullPointerException("No value for required property: cayenne.dbcp.url");
        }
        return new DriverManagerConnectionFactory(url, userName, password);
    }

    GenericObjectPool.Config createPoolConfig(Properties properties) throws Exception {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = this.intProperty(properties, "maxIdle", 8);
        config.minIdle = this.intProperty(properties, "minIdle", 0);
        config.maxActive = this.intProperty(properties, "maxActive", 8);
        config.maxWait = this.longProperty(properties, "maxWait", -1L);
        config.testOnBorrow = this.booleanProperty(properties, "testOnBorrow", false);
        config.testOnReturn = this.booleanProperty(properties, "testOnReturn", false);
        config.testWhileIdle = this.booleanProperty(properties, "testWhileIdle", false);
        config.timeBetweenEvictionRunsMillis = this.longProperty(properties, "timeBetweenEvictionRunsMillis", -1L);
        config.numTestsPerEvictionRun = this.intProperty(properties, "numTestsPerEvictionRun", 3);
        config.minEvictableIdleTimeMillis = this.longProperty(properties, "minEvictableIdleTimeMillis", 1800000L);
        config.whenExhaustedAction = this.whenExhaustedAction(properties, "whenExhaustedAction", (byte)1);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadProperties(String location) throws IOException {
        Properties properties = new Properties();
        InputStream in = this.getInputStream(location);
        if (in == null) {
            throw new ConfigurationException("DBCP properties file not found: " + location);
        }
        try {
            properties.load(in);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        return properties;
    }

    int defaultTransactionIsolation(Properties properties, String property, int defaultValue) {
        String value = this.stringProperty(properties, property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfex) {
            try {
                return Connection.class.getField(value).getInt(null);
            }
            catch (Throwable th) {
                throw new ConfigurationException("Invalid 'defaultTransactionIsolation': " + value);
            }
        }
    }

    byte whenExhaustedAction(Properties properties, String property, byte defaultValue) throws Exception {
        String value = this.stringProperty(properties, property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException nfex) {
            try {
                return GenericObjectPool.class.getField(value).getByte(null);
            }
            catch (Throwable th) {
                throw new ConfigurationException("Invalid 'whenExhaustedAction': " + value);
            }
        }
    }

    String stringProperty(Properties properties, String property) {
        return properties.getProperty(PROPERTY_PREFIX + property);
    }

    boolean booleanProperty(Properties properties, String property, boolean defaultValue) {
        String value = this.stringProperty(properties, property);
        return value != null ? "true".equalsIgnoreCase(this.stringProperty(properties, property)) : defaultValue;
    }

    int intProperty(Properties properties, String property, int defaultValue) {
        String value = this.stringProperty(properties, property);
        try {
            return value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    long longProperty(Properties properties, String property, long defaultValue) {
        String value = this.stringProperty(properties, property);
        try {
            return value != null ? Long.parseLong(value) : defaultValue;
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    byte byteProperty(Properties properties, String property, byte defaultValue) {
        String value = this.stringProperty(properties, property);
        try {
            return value != null ? Byte.parseByte(value) : defaultValue;
        }
        catch (NumberFormatException nfex) {
            return defaultValue;
        }
    }

    InputStream getInputStream(String location) {
        if (this.parentConfiguration == null) {
            throw new ConfigurationException("No parent Configuration set - cannot continue.");
        }
        return this.parentConfiguration.getResourceLocator().findResourceStream(location);
    }
}

