/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.ParseException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.MaskFormatter;
import org.objectstyle.cayenne.dataview.CellRenderers;
import org.objectstyle.cayenne.dataview.DOTableModel;
import org.objectstyle.cayenne.dataview.MapFormat;
import org.objectstyle.cayenne.dataview.ObjEntityViewField;

public class CellEditors {
    protected Border editStateBorder = new LineBorder(Color.black);
    protected Border invalidStateBorder = new LineBorder(Color.red);

    public FormattedFieldEditor createFormattedFieldEditor(JFormattedTextField.AbstractFormatter formatter, int alignment) {
        JFormattedTextField field = new JFormattedTextField(formatter);
        if (alignment >= 0) {
            field.setHorizontalAlignment(alignment);
        }
        return new FormattedFieldEditor(field);
    }

    public FormattedFieldEditor createFormattedFieldEditor(Format formatter, int alignment) {
        JFormattedTextField field = new JFormattedTextField(formatter);
        if (alignment >= 0) {
            field.setHorizontalAlignment(alignment);
        }
        return new FormattedFieldEditor(field);
    }

    public FormattedFieldEditor createFormattedFieldEditor(String mask, int alignment) throws ParseException {
        MaskFormatter formatter = new MaskFormatter(mask);
        return this.createFormattedFieldEditor(formatter, alignment);
    }

    public TextFieldEditor createTextFieldEditor(int alignment) {
        JTextField field = new JTextField();
        if (alignment >= 0) {
            field.setHorizontalAlignment(alignment);
        }
        return new TextFieldEditor(field);
    }

    public CheckBoxEditor createCheckBoxEditor() {
        JCheckBox checkBox = new JCheckBox();
        return new CheckBoxEditor(checkBox);
    }

    public ComboBoxEditor createComboBoxEditor(ComboBoxModel model, ListCellRenderer renderer) {
        JComboBox comboBox = new JComboBox(model);
        if (renderer != null) {
            comboBox.setRenderer(renderer);
        }
        return new ComboBoxEditor(comboBox);
    }

    public ButtonEditor createButtonEditor(JButton button) {
        return new ButtonEditor(button);
    }

    public SpinnerEditor createSpinnerEditor(SpinnerModel model, Format format) {
        JFormattedTextField field;
        JFormattedTextField.AbstractFormatter formatter;
        JSpinner spinner = new JSpinner(model);
        if (format != null && (formatter = (field = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField()).getFormatter()) instanceof InternationalFormatter) {
            ((InternationalFormatter)formatter).setFormat(format);
        }
        return new SpinnerEditor(spinner);
    }

    public TableCellEditor createTableCellEditor(ObjEntityViewField field) {
        int alignment;
        CellRenderers cellRenderers = new CellRenderers();
        DefaultCellEditor editor = null;
        Format format = field.getEditFormat();
        int dataType = field.getDataType().getValue();
        boolean lookup = field.isLookup();
        switch (dataType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                alignment = 4;
                break;
            }
            default: {
                alignment = 2;
            }
        }
        if (lookup) {
            DefaultComboBoxModel<Object> comboData = new DefaultComboBoxModel<Object>(field.getLookupValues());
            ListCellRenderer comboRenderer = cellRenderers.createListCellRenderer(field);
            editor = this.createComboBoxEditor(comboData, comboRenderer);
        } else if (format != null) {
            if (format instanceof MapFormat) {
                MapFormat mapFormat = (MapFormat)format;
                DefaultComboBoxModel<Object> comboData = new DefaultComboBoxModel<Object>(mapFormat.getValues());
                ListCellRenderer comboRenderer = cellRenderers.createFormatListCellRenderer(mapFormat, mapFormat.getNullFormat(), null, -1);
                editor = this.createComboBoxEditor(comboData, comboRenderer);
            } else {
                editor = this.createFormattedFieldEditor(format, alignment);
            }
        } else {
            editor = dataType == 9 ? this.createCheckBoxEditor() : this.createTextFieldEditor(alignment);
        }
        return editor;
    }

    public void installEditors(JTable table) {
        TableModel m = table.getModel();
        if (!(m instanceof DOTableModel)) {
            return;
        }
        DOTableModel model = (DOTableModel)m;
        TableColumnModel columnModel = table.getColumnModel();
        int columnCount = model.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            ObjEntityViewField field = model.getField(i);
            TableCellEditor editor = this.createTableCellEditor(field);
            TableColumn column = columnModel.getColumn(i);
            column.setCellEditor(editor);
        }
    }

    public class ButtonEditor
    extends DefaultCellEditor {
        protected Object currentValue;

        public ButtonEditor(JButton button) {
            super(new JCheckBox());
            this.editorComponent = button;
            this.setClickCountToStart(1);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
            button.setBorder(CellEditors.this.editStateBorder);
            button.setFocusPainted(false);
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JButton)this.editorComponent).setText(String.valueOf(value));
            this.currentValue = value;
            return this.editorComponent;
        }
    }

    public class SpinnerEditor
    extends DefaultCellEditor {
        public SpinnerEditor(final JSpinner spinner) {
            super(new JTextField());
            this.editorComponent = spinner;
            spinner.setBorder(CellEditors.this.editStateBorder);
            spinner.getEditor().setBorder(null);
            final JFormattedTextField field = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
            field.setBorder(null);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    spinner.setValue(value);
                }

                public Object getCellEditorValue() {
                    return spinner.getValue();
                }

                public boolean stopCellEditing() {
                    if (field.isEditValid()) {
                        try {
                            field.commitEdit();
                        }
                        catch (ParseException parseException) {}
                    } else {
                        field.setBorder(((SpinnerEditor)SpinnerEditor.this).CellEditors.this.invalidStateBorder);
                        return false;
                    }
                    return super.stopCellEditing();
                }
            };
            field.addActionListener(this.delegate);
        }
    }

    public class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor(JComboBox comboBox) {
            super(comboBox);
            comboBox.setBorder(CellEditors.this.editStateBorder);
        }
    }

    public class CheckBoxEditor
    extends DefaultCellEditor {
        public CheckBoxEditor(JCheckBox checkBox) {
            super(checkBox);
            checkBox.setBorder(CellEditors.this.editStateBorder);
            checkBox.setHorizontalAlignment(0);
        }
    }

    public class TextFieldEditor
    extends DefaultCellEditor {
        protected Border editStateBorder;

        public TextFieldEditor(JTextField field) {
            super(field);
            this.editStateBorder = new LineBorder(Color.black);
            field.setBorder(this.editStateBorder);
        }
    }

    public class FormattedFieldEditor
    extends DefaultCellEditor {
        public FormattedFieldEditor(final JFormattedTextField field) {
            super(field);
            field.removeActionListener(this.delegate);
            this.clickCountToStart = 2;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    field.setValue(value);
                }

                public Object getCellEditorValue() {
                    return field.getValue();
                }

                public boolean stopCellEditing() {
                    if (field.isEditValid()) {
                        try {
                            field.commitEdit();
                        }
                        catch (ParseException parseException) {}
                    } else {
                        field.setBorder(((FormattedFieldEditor)FormattedFieldEditor.this).CellEditors.this.invalidStateBorder);
                        return false;
                    }
                    return super.stopCellEditing();
                }
            };
            field.addActionListener(this.delegate);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.delegate.setValue(value);
            if (((JFormattedTextField)this.editorComponent).isEditValid()) {
                this.editorComponent.setBorder(CellEditors.this.editStateBorder);
            } else {
                this.editorComponent.setBorder(CellEditors.this.invalidStateBorder);
            }
            return this.editorComponent;
        }
    }
}

