/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.dataview.ObjEntityViewField;

public class LookupCache {
    private Map fieldCache = new HashMap();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public void cache(ObjEntityViewField field, List dataObjects) {
        Lookup lookup = this.getLookup(field);
        if (lookup == null) {
            lookup = new Lookup();
            this.fieldCache.put(field, lookup);
        }
        lookup.cache(field, dataObjects);
    }

    public void clear() {
        this.fieldCache.clear();
    }

    public boolean removeFromCache(ObjEntityViewField field) {
        return this.fieldCache.remove(field) != null;
    }

    public Object[] getCachedValues(ObjEntityViewField field) {
        Object[] values;
        Lookup lookup = this.getLookup(field);
        Object[] objectArray = values = lookup != null ? lookup.values : EMPTY_ARRAY;
        if (values.length == 0) {
            return values;
        }
        Object[] valuesCopy = new Object[values.length];
        System.arraycopy(values, 0, valuesCopy, 0, values.length);
        return valuesCopy;
    }

    public DataObject getDataObject(ObjEntityViewField field, Object value) {
        Lookup lookup = this.getLookup(field);
        if (lookup == null) {
            return null;
        }
        return lookup.getDataObject(value);
    }

    private Lookup getLookup(ObjEntityViewField field) {
        if (field == null) {
            return null;
        }
        return (Lookup)this.fieldCache.get(field);
    }

    static /* synthetic */ Object[] access$100() {
        return EMPTY_ARRAY;
    }

    private class Lookup {
        ObjEntityViewField field;
        Object[] values = LookupCache.access$100();
        Map valueDataObjectMap;

        private Lookup() {
        }

        void cache(ObjEntityViewField field, List dataObjects) {
            this.field = field;
            if (this.values.length != dataObjects.size()) {
                this.values = new Object[dataObjects.size()];
            }
            this.valueDataObjectMap = new HashMap(this.values.length + 1);
            int index = 0;
            Iterator i = dataObjects.iterator();
            while (i.hasNext()) {
                DataObject item = (DataObject)i.next();
                this.values[index] = field.getValue(item);
                this.valueDataObjectMap.put(this.values[index], item);
                ++index;
            }
        }

        DataObject getDataObject(Object value) {
            return (DataObject)this.valueDataObjectMap.get(value);
        }
    }
}

