/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.openbase;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.DefaultType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.dba.openbase.OpenBaseActionBuilder;
import org.objectstyle.cayenne.dba.openbase.OpenBasePkGenerator;
import org.objectstyle.cayenne.dba.openbase.OpenBaseQualifierTranslator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.DerivedDbEntity;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;

public class OpenBaseAdapter
extends JdbcAdapter {
    private static Logger logObj = Logger.getLogger(OpenBaseAdapter.class);
    static /* synthetic */ Class class$java$lang$Byte;

    public OpenBaseAdapter() {
        this.setSupportsUniqueConstraints(false);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new OpenBaseActionBuilder(this, node.getEntityResolver()));
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new OpenBaseByteType());
        map.registerType(new OpenBaseCharType());
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (type == 1) {
            type = 12;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    public String getBatchTerminator() {
        return "go";
    }

    public String tableTypeForView() {
        return null;
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new OpenBaseQualifierTranslator(queryAssembler);
    }

    protected PkGenerator createPkGenerator() {
        return new OpenBasePkGenerator();
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (TypesMapping.supportsLength(at.getType())) {
                int prec;
                int len = at.getMaxLength();
                int n = prec = TypesMapping.isDecimal(at.getType()) ? at.getPrecision() : -1;
                if (prec > len) {
                    prec = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (prec >= 0) {
                        buf.append(", ").append(prec);
                    }
                    buf.append(')');
                }
            }
            if (at.isMandatory()) {
                buf.append(" NOT NULL");
                continue;
            }
            buf.append(" NULL");
        }
        buf.append(')');
        return buf.toString();
    }

    public String createFkConstraint(DbRelationship rel) {
        StringBuffer buf = new StringBuffer();
        DbEntity sourceEntity = (DbEntity)rel.getSourceEntity();
        DbEntity targetEntity = (DbEntity)rel.getTargetEntity();
        String toMany = !rel.isToMany() ? "'1'" : "'0'";
        int joinsLen = rel.getJoins().size();
        if (joinsLen == 0) {
            throw new CayenneRuntimeException("Relationship has no joins: " + rel.getName());
        }
        if (joinsLen > 1) {
            logObj.warn("Only a single join relationships are supported by OpenBase. Ignoring extra joins.");
        }
        DbJoin join = (DbJoin)rel.getJoins().get(0);
        buf.append("INSERT INTO _SYS_RELATIONSHIP (").append("dest_table, dest_column, source_table, source_column, ").append("block_delete, cascade_delete, one_to_many, operator, relationshipName").append(") VALUES ('").append(sourceEntity.getFullyQualifiedName()).append("', '").append(join.getSourceName()).append("', '").append(targetEntity.getFullyQualifiedName()).append("', '").append(join.getTargetName()).append("', 0, 0, ").append(toMany).append(", '=', '").append(rel.getName()).append("')");
        return buf.toString();
    }

    static class OpenBaseCharType
    extends CharType {
        OpenBaseCharType() {
            super(false, true);
        }

        public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
            if (type == 2005 || type == -1) {
                st.setString(pos, (String)val);
            } else {
                super.setJdbcObject(st, val, pos, type, precision);
            }
        }
    }

    static class OpenBaseByteType
    extends DefaultType {
        OpenBaseByteType() {
            super((class$java$lang$Byte == null ? (class$java$lang$Byte = OpenBaseAdapter.class$("java.lang.Byte")) : class$java$lang$Byte).getName());
        }

        public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
            int val = rs.getInt(index);
            return rs.wasNull() ? null : new Byte((byte)val);
        }
    }
}

