/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.event;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class EventSubject
implements Serializable {
    private static Map _registeredSubjects = new ReferenceMap(0, 2);
    private String _fullyQualifiedSubjectName;

    public static EventSubject getSubject(Class subjectOwner, String subjectName) {
        if (subjectOwner == null) {
            throw new IllegalArgumentException("Owner class must not be null.");
        }
        if (subjectName == null || subjectName.length() == 0) {
            throw new IllegalArgumentException("Subject name must not be null or empty.");
        }
        String fullSubjectName = subjectOwner.getName() + "/" + subjectName;
        EventSubject newSubject = (EventSubject)_registeredSubjects.get(fullSubjectName);
        if (newSubject == null) {
            newSubject = new EventSubject(fullSubjectName);
            _registeredSubjects.put(newSubject.getSubjectName(), newSubject);
        }
        return newSubject;
    }

    private EventSubject() {
    }

    protected EventSubject(String fullSubjectName) {
        this._fullyQualifiedSubjectName = fullSubjectName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventSubject) {
            return this._fullyQualifiedSubjectName.equals(((EventSubject)obj).getSubjectName());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 3).append(this._fullyQualifiedSubjectName).toHashCode();
    }

    public String getSubjectName() {
        return this._fullyQualifiedSubjectName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("<");
        buf.append(this.getClass().getName());
        buf.append(" 0x");
        buf.append(Integer.toHexString(System.identityHashCode(this)));
        buf.append("> ");
        buf.append(this._fullyQualifiedSubjectName);
        return buf.toString();
    }
}

