/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.exp.parser;

import java.util.regex.Pattern;
import org.objectstyle.cayenne.exp.parser.ASTScalar;
import org.objectstyle.cayenne.exp.parser.ConditionNode;
import org.objectstyle.cayenne.exp.parser.Node;
import org.objectstyle.cayenne.util.Util;

public abstract class PatternMatchNode
extends ConditionNode {
    protected Pattern pattern;
    protected boolean patternCompiled;
    protected boolean ignoringCase;

    PatternMatchNode(int i, boolean ignoringCase) {
        super(i);
        this.ignoringCase = ignoringCase;
    }

    protected boolean matchPattern(String string) {
        return string != null ? this.getPattern().matcher(string).find() : false;
    }

    protected Pattern getPattern() {
        if (!this.patternCompiled) {
            this.pattern = null;
            this.patternCompiled = true;
            if (this.jjtGetNumChildren() < 2) {
                return null;
            }
            ASTScalar patternNode = (ASTScalar)this.jjtGetChild(1);
            if (patternNode == null) {
                return null;
            }
            String srcPattern = (String)patternNode.getValue();
            if (srcPattern == null) {
                return null;
            }
            this.pattern = Util.sqlPatternToPattern(srcPattern, this.ignoringCase);
        }
        return this.pattern;
    }

    public void jjtAddChild(Node n, int i) {
        if (i == 1) {
            this.patternCompiled = false;
        }
        super.jjtAddChild(n, i);
    }
}

