/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.exp.parser;

import java.io.PrintWriter;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionException;
import org.objectstyle.cayenne.exp.parser.ASTScalar;
import org.objectstyle.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.objectstyle.cayenne.exp.parser.Node;
import org.objectstyle.cayenne.util.Util;

public abstract class SimpleNode
extends Expression
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;

    protected static void encodeScalarAsString(PrintWriter pw, Object scalar) {
        boolean quote = scalar instanceof String;
        if (quote) {
            pw.print('\"');
        }
        SimpleNode.encodeAsEscapedString(pw, String.valueOf(scalar));
        if (quote) {
            pw.print('\"');
        }
    }

    protected static void encodeAsEscapedString(PrintWriter pw, String source) {
        int len = source.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\n': {
                    pw.print("\\n");
                    continue block10;
                }
                case '\r': {
                    pw.print("\\r");
                    continue block10;
                }
                case '\t': {
                    pw.print("\\t");
                    continue block10;
                }
                case '\b': {
                    pw.print("\\b");
                    continue block10;
                }
                case '\f': {
                    pw.print("\\f");
                    continue block10;
                }
                case '\\': {
                    pw.print("\\\\");
                    continue block10;
                }
                case '\'': {
                    pw.print("\\'");
                    continue block10;
                }
                case '\"': {
                    pw.print("\\\"");
                    continue block10;
                }
                default: {
                    pw.print(c);
                }
            }
        }
    }

    protected SimpleNode(int i) {
        this.id = i;
    }

    protected abstract String getExpressionOperator(int var1);

    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return true;
    }

    public String expName() {
        return ExpressionParserTreeConstants.jjtNodeName[this.id];
    }

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += this.children[i].jjtGetNumChildren();
                continue;
            }
            ++newSize;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            for (int i = 0; i < this.children.length; ++i) {
                Node c = this.children[i];
                if (c.getClass() == this.getClass()) {
                    for (int k = 0; k < c.jjtGetNumChildren(); ++k) {
                        newChildren[j++] = c.jjtGetChild(k);
                    }
                    continue;
                }
                newChildren[j++] = c;
            }
            if (j != newSize) {
                throw new ExpressionException("Assertion error: " + j + " != " + newSize);
            }
            this.children = newChildren;
        }
    }

    public void encodeAsString(PrintWriter pw) {
        if (this.parent != null) {
            pw.print("(");
        }
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    pw.print(' ');
                    pw.print(this.getExpressionOperator(i));
                    pw.print(' ');
                }
                ((SimpleNode)this.children[i]).encodeAsString(pw);
            }
        }
        if (this.parent != null) {
            pw.print(')');
        }
    }

    public Object getOperand(int index) {
        Node child = this.jjtGetChild(index);
        return this.unwrapChild(child);
    }

    protected Node wrapChild(Object child) {
        return child instanceof Node || child == null ? (Node)child : new ASTScalar(child);
    }

    protected Object unwrapChild(Node child) {
        return child instanceof ASTScalar ? ((ASTScalar)child).getValue() : child;
    }

    public int getOperandCount() {
        return this.jjtGetNumChildren();
    }

    public void setOperand(int index, Object value) {
        Node node = value == null || value instanceof Node ? (Node)value : new ASTScalar(value);
        this.jjtAddChild(node, index);
        if (node != null) {
            node.jjtSetParent(this);
        }
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public final int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    protected abstract Object evaluateNode(Object var1) throws Exception;

    protected Object evaluateChild(int index, Object o) throws Exception {
        return ((SimpleNode)this.jjtGetChild(index)).evaluate(o);
    }

    public Object evaluate(Object o) {
        try {
            return this.evaluateNode(o);
        }
        catch (Throwable th) {
            String string = this.toString();
            throw new ExpressionException("Error evaluating expression '" + string + "'", string, Util.unwindException(th));
        }
    }
}

