/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.gen.StringUtils;
import org.objectstyle.cayenne.util.Util;

public class ImportUtils {
    public static final String[] importOrdering = new String[]{"java.", "javax.", "org.", "com."};
    static final String[] primitives = new String[]{"long", "double", "byte", "boolean", "float", "short", "int"};
    static final String[] primitiveClasses = new String[]{Long.class.getName(), Double.class.getName(), Byte.class.getName(), Boolean.class.getName(), Float.class.getName(), Short.class.getName(), Integer.class.getName()};
    static Map classesForPrimitives = Util.toMap(primitives, primitiveClasses);
    static Map primitivesForClasses = Util.toMap(primitiveClasses, primitives);
    protected Map importTypesMap = new HashMap();
    protected Map reservedImportTypesMap = new HashMap();
    protected String packageName;

    protected boolean canRegisterType(String typeName) {
        if (null == typeName) {
            return false;
        }
        StringUtils stringUtils = StringUtils.getInstance();
        String typeClassName = stringUtils.stripPackageName(typeName);
        String typePackageName = stringUtils.stripClass(typeName);
        if (typePackageName.length() == 0) {
            return false;
        }
        if ("java.lang".equals(typePackageName)) {
            return false;
        }
        if (this.reservedImportTypesMap.containsKey(typeClassName)) {
            return false;
        }
        return !this.importTypesMap.containsKey(typeClassName);
    }

    public void addReservedType(String typeName) {
        if (!this.canRegisterType(typeName)) {
            return;
        }
        StringUtils stringUtils = StringUtils.getInstance();
        String typeClassName = stringUtils.stripPackageName(typeName);
        this.reservedImportTypesMap.put(typeClassName, typeName);
    }

    public void addType(String typeName) {
        if (!this.canRegisterType(typeName)) {
            return;
        }
        StringUtils stringUtils = StringUtils.getInstance();
        String typePackageName = stringUtils.stripClass(typeName);
        String typeClassName = stringUtils.stripPackageName(typeName);
        if (typePackageName.equals(this.packageName)) {
            return;
        }
        this.importTypesMap.put(typeClassName, typeName);
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public String formatJavaType(String typeName, boolean usePrimitives) {
        if (usePrimitives) {
            String primitive = (String)primitivesForClasses.get(typeName);
            return primitive != null ? primitive : this.formatJavaType(typeName);
        }
        String primitiveClass = (String)classesForPrimitives.get(typeName);
        return primitiveClass != null ? this.formatJavaType(primitiveClass) : this.formatJavaType(typeName);
    }

    public String formatJavaType(String typeName) {
        if (typeName != null) {
            StringUtils stringUtils = StringUtils.getInstance();
            String typeClassName = stringUtils.stripPackageName(typeName);
            if (!this.reservedImportTypesMap.containsKey(typeClassName) && this.importTypesMap.containsKey(typeClassName) && typeName.equals(this.importTypesMap.get(typeClassName))) {
                return typeClassName;
            }
            String typePackageName = stringUtils.stripClass(typeName);
            if ("java.lang".equals(typePackageName)) {
                return typeClassName;
            }
            if (null != this.packageName && this.packageName.equals(typePackageName)) {
                return typeClassName;
            }
        }
        return typeName;
    }

    public String generate() {
        StringBuffer outputBuffer = new StringBuffer();
        if (null != this.packageName) {
            outputBuffer.append("package ");
            outputBuffer.append(this.packageName);
            outputBuffer.append(';');
            outputBuffer.append(System.getProperty("line.separator"));
            outputBuffer.append(System.getProperty("line.separator"));
        }
        ArrayList typesList = new ArrayList(this.importTypesMap.values());
        Collections.sort(typesList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                for (int index = 0; index < importOrdering.length; ++index) {
                    String ordering = importOrdering[index];
                    if (s1.startsWith(ordering) && !s2.startsWith(ordering)) {
                        return -1;
                    }
                    if (s1.startsWith(ordering) || !s2.startsWith(ordering)) continue;
                    return 1;
                }
                return s1.compareTo(s2);
            }
        });
        String lastStringPrefix = null;
        Iterator typesIterator = typesList.iterator();
        while (typesIterator.hasNext()) {
            String typeName;
            String thisStringPrefix = typeName = (String)typesIterator.next();
            int dotIndex = typeName.indexOf(46);
            if (-1 != dotIndex) {
                thisStringPrefix = typeName.substring(0, dotIndex);
            }
            if (null != lastStringPrefix && !thisStringPrefix.equals(lastStringPrefix)) {
                outputBuffer.append(System.getProperty("line.separator"));
            }
            lastStringPrefix = thisStringPrefix;
            outputBuffer.append("import ");
            outputBuffer.append(typeName);
            outputBuffer.append(';');
            if (!typesIterator.hasNext()) continue;
            outputBuffer.append(System.getProperty("line.separator"));
        }
        return outputBuffer.toString();
    }
}

