/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.graph;

import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.NodeDiff;
import org.objectstyle.cayenne.util.Util;

public class NodePropertyChangeOperation
extends NodeDiff {
    protected String property;
    protected Object oldValue;
    protected Object newValue;

    public NodePropertyChangeOperation(Object nodeId, String property, Object oldValue, Object newValue) {
        super(nodeId);
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public NodePropertyChangeOperation(Object nodeId, String property, Object oldValue, Object newValue, int diffId) {
        super(nodeId, diffId);
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public boolean isNoop() {
        return Util.nullSafeEquals(this.oldValue, this.newValue);
    }

    public void apply(GraphChangeHandler tracker) {
        tracker.nodePropertyChanged(this.nodeId, this.property, this.oldValue, this.newValue);
    }

    public void undo(GraphChangeHandler tracker) {
        tracker.nodePropertyChanged(this.nodeId, this.property, this.newValue, this.oldValue);
    }
}

