/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.map.EntityInheritanceTree;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.property.AbstractSingleObjectArcProperty;
import org.objectstyle.cayenne.property.BaseClassDescriptor;
import org.objectstyle.cayenne.property.BeanAccessor;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.DataObjectAccessor;
import org.objectstyle.cayenne.property.FieldAccessor;
import org.objectstyle.cayenne.property.ListProperty;
import org.objectstyle.cayenne.property.PersistentObjectProperty;
import org.objectstyle.cayenne.property.Property;
import org.objectstyle.cayenne.property.PropertyAccessException;
import org.objectstyle.cayenne.property.PropertyAccessor;
import org.objectstyle.cayenne.property.SimpleProperty;
import org.objectstyle.cayenne.property.ToManyListProperty;
import org.objectstyle.cayenne.property.ValueHolderProperty;

public class EntityDescriptor
extends BaseClassDescriptor {
    protected ObjEntity entity;
    protected boolean dataObject;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$objectstyle$cayenne$ValueHolder;

    public EntityDescriptor(ObjEntity entity, ClassDescriptor superclassDescriptor) {
        super(superclassDescriptor);
        this.entity = entity;
    }

    public void shallowMerge(Object from, Object to) throws PropertyAccessException {
        super.shallowMerge(from, to);
        if (this.dataObject && from instanceof DataObject && to instanceof DataObject) {
            ((DataObject)to).setSnapshotVersion(((DataObject)from).getSnapshotVersion());
        }
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    public void setDeclaredProperty(Property property) {
        this.declaredProperties.put(property.getName(), property);
    }

    public void removeDeclaredProperty(String propertyName) {
        this.declaredProperties.remove(propertyName);
    }

    public void compile(EntityResolver resolver) {
        if (this.entity == null) {
            throw new IllegalStateException("Entity is not initialized, can't index descriptor.");
        }
        this.objectClass = this.entity.getJavaClass();
        this.dataObject = DataObject.class.isAssignableFrom(this.objectClass);
        this.compileSpecialProperties();
        HashMap allDescriptors = new HashMap();
        this.compileAttributes(allDescriptors);
        this.compileRelationships(resolver, allDescriptors);
        this.declaredProperties = allDescriptors;
        EntityInheritanceTree inheritanceTree = resolver.lookupInheritanceTree(this.entity);
        if (inheritanceTree == null) {
            this.subclassDescriptors = null;
        } else {
            HashMap subclassMapping = new HashMap();
            this.compileSubclassMapping(resolver, subclassMapping, inheritanceTree);
            this.subclassDescriptors = subclassMapping;
        }
    }

    protected void compileSubclassMapping(EntityResolver resolver, Map subclassDescriptors, EntityInheritanceTree treeNode) {
        ObjEntity entity = treeNode.getEntity();
        ClassDescriptor descriptor = resolver.getClassDescriptor(entity.getName());
        subclassDescriptors.put(entity.getClassName(), descriptor);
        Iterator it = treeNode.getChildren().iterator();
        while (it.hasNext()) {
            EntityInheritanceTree child = (EntityInheritanceTree)it.next();
            this.compileSubclassMapping(resolver, subclassDescriptors, child);
        }
    }

    protected void compileSpecialProperties() {
        this.persistenceStateProperty = new BeanAccessor(this.objectClass, "persistenceState", Integer.TYPE);
    }

    protected void compileAttributes(Map allDescriptors) {
        Iterator it = this.entity.getDeclaredAttributes().iterator();
        while (it.hasNext()) {
            ObjAttribute attribute = (ObjAttribute)it.next();
            Class propertyType = attribute.getJavaClass();
            PropertyAccessor accessor = this.makeAccessor(attribute.getName(), propertyType);
            allDescriptors.put(attribute.getName(), new SimpleProperty(this, accessor));
        }
    }

    protected void compileRelationships(EntityResolver resolver, Map allDescriptors) {
        Iterator it = this.entity.getDeclaredRelationships().iterator();
        while (it.hasNext()) {
            AbstractSingleObjectArcProperty property;
            PropertyAccessor accessor;
            ObjRelationship relationship = (ObjRelationship)it.next();
            ClassDescriptor targetDescriptor = resolver.getClassDescriptor(relationship.getTargetEntityName());
            String reverseName = relationship.getReverseRelationshipName();
            if (relationship.isToMany()) {
                accessor = this.makeAccessor(relationship.getName(), class$java$util$List == null ? EntityDescriptor.class$("java.util.List") : class$java$util$List);
                property = this.dataObject ? new ToManyListProperty(this, targetDescriptor, accessor, reverseName) : new ListProperty(this, targetDescriptor, accessor, reverseName);
            } else if (this.dataObject) {
                ObjEntity targetEntity = (ObjEntity)relationship.getTargetEntity();
                PropertyAccessor accessor2 = this.makeAccessor(relationship.getName(), targetEntity.getJavaClass());
                property = new PersistentObjectProperty(this, targetDescriptor, accessor2, reverseName);
            } else {
                accessor = this.makeAccessor(relationship.getName(), class$org$objectstyle$cayenne$ValueHolder == null ? EntityDescriptor.class$("org.objectstyle.cayenne.ValueHolder") : class$org$objectstyle$cayenne$ValueHolder);
                property = new ValueHolderProperty(this, targetDescriptor, accessor, reverseName);
            }
            allDescriptors.put(relationship.getName(), property);
        }
    }

    PropertyAccessor makeAccessor(String propertyName, Class propertyType) throws PropertyAccessException {
        try {
            return new FieldAccessor(this.objectClass, propertyName, propertyType);
        }
        catch (Throwable th) {
            if (this.dataObject) {
                return new DataObjectAccessor(propertyName);
            }
            throw new PropertyAccessException("Can't create accessor for property '" + propertyName + "' of class '" + this.objectClass.getName() + "'", null, null);
        }
    }

    public String toString() {
        String entityName = this.entity != null ? this.entity.getName() : null;
        String className = this.objectClass != null ? this.objectClass.getName() : null;
        return new ToStringBuilder(this).append("entity", entityName).append("objectClass", className).toString();
    }
}

