/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.Ordering;
import org.objectstyle.cayenne.query.Query;

public abstract class QueryBuilder {
    public static final String OBJ_ENTITY_ROOT = "obj-entity";
    public static final String DB_ENTITY_ROOT = "db-entity";
    public static final String PROCEDURE_ROOT = "procedure";
    public static final String DATA_MAP_ROOT = "data-map";
    public static final String JAVA_CLASS_ROOT = "java-class";
    protected String name;
    protected Map properties;
    protected List resultColumns;
    protected String sql;
    protected Map adapterSql;
    protected Expression qualifier;
    protected List orderings;
    protected List prefetches;
    protected DataMap dataMap;
    protected String rootType;
    protected String rootName;
    protected boolean selecting = true;
    protected String resultEntity;

    public abstract Query getQuery();

    public void setName(String name) {
        this.name = name;
    }

    protected Object getRoot() {
        Serializable root = null;
        if (this.rootType == null || DATA_MAP_ROOT.equals(this.rootType) || this.rootName == null) {
            root = this.dataMap;
        } else if (OBJ_ENTITY_ROOT.equals(this.rootType)) {
            root = this.dataMap.getObjEntity(this.rootName);
        } else if (DB_ENTITY_ROOT.equals(this.rootType)) {
            root = this.dataMap.getDbEntity(this.rootName);
        } else if (PROCEDURE_ROOT.equals(this.rootType)) {
            root = this.dataMap.getProcedure(this.rootName);
        } else if (JAVA_CLASS_ROOT.equals(this.rootType)) {
            root = this.dataMap.getObjEntityForJavaClass(this.rootName);
        }
        return root != null ? root : this.dataMap;
    }

    public void setSelecting(String selecting) {
        this.selecting = !"false".equalsIgnoreCase(selecting);
    }

    public void setResultType(String resultType) {
        this.resultEntity = null;
        if (resultType != null) {
            Iterator it = this.dataMap.getObjEntities().iterator();
            while (it.hasNext()) {
                ObjEntity next = (ObjEntity)it.next();
                if (!resultType.equals(next.getClassName())) continue;
                this.resultEntity = next.getName();
                break;
            }
        }
    }

    public void setResultEntity(String resultEntity) {
        this.resultEntity = resultEntity;
    }

    public void setRoot(DataMap dataMap, String rootType, String rootName) {
        this.dataMap = dataMap;
        this.rootType = rootType;
        this.rootName = rootName;
    }

    public void addSql(String sql, String adapterClass) {
        if (adapterClass == null) {
            this.sql = sql;
        } else {
            if (this.adapterSql == null) {
                this.adapterSql = new HashMap();
            }
            this.adapterSql.put(adapterClass, sql);
        }
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier == null || qualifier.trim().length() == 0 ? null : Expression.fromString(qualifier.trim());
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public void addResultColumn(String label, String dbType, String objectType) {
        if (this.resultColumns == null) {
            this.resultColumns = new ArrayList();
        }
        this.resultColumns.add(new ResultColumn(label, dbType, objectType));
    }

    public void addOrdering(String path, String descending, String ignoreCase) {
        if (this.orderings == null) {
            this.orderings = new ArrayList();
        }
        if (path != null && path.trim().length() == 0) {
            path = null;
        }
        boolean isDescending = "true".equalsIgnoreCase(descending);
        boolean isIgnoringCase = "true".equalsIgnoreCase(ignoreCase);
        this.orderings.add(new Ordering(path, !isDescending, isIgnoringCase));
    }

    public void addPrefetch(String path) {
        if (path == null || path != null && path.trim().length() == 0) {
            return;
        }
        if (this.prefetches == null) {
            this.prefetches = new ArrayList();
        }
        this.prefetches.add(path.trim());
    }

    static class ResultColumn {
        String label;
        String dbType;
        String objectType;

        ResultColumn(String label, String dbType, String objectType) {
            this.label = label;
            this.dbType = dbType;
            this.objectType = objectType;
        }
    }
}

