/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project;

import java.io.File;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.project.ProjectException;

public class DataNodeConfigInfo {
    protected String name;
    protected String domain;
    protected String adapter;
    protected String dataSource;
    protected File driverFile;

    public DataNode findDataNode(Configuration config) throws ProjectException {
        DataNode node;
        DataDomain domainObj = null;
        if (this.domain != null) {
            domainObj = config.getDomain(this.domain);
            if (domainObj == null) {
                throw new ProjectException("Can't find domain named " + this.domain);
            }
        } else {
            try {
                domainObj = config.getDomain();
            }
            catch (Exception ex) {
                throw new ProjectException("Project has no default domain.", ex);
            }
            if (domainObj == null) {
                throw new ProjectException("Project has no domains configured.");
            }
        }
        if ((node = domainObj.getNode(this.name)) == null) {
            throw new ProjectException("Domain " + domainObj.getName() + " has no node named '" + this.name + "'.");
        }
        return node;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDomain() {
        return this.domain;
    }

    public File getDriverFile() {
        return this.driverFile;
    }

    public String getName() {
        return this.name;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setDriverFile(File driverFile) {
        this.driverFile = driverFile;
    }

    public void setName(String name) {
        this.name = name;
    }
}

