/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project;

import java.io.File;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.ConfigurationException;
import org.objectstyle.cayenne.conf.DriverDataSourceFactory;
import org.objectstyle.cayenne.conn.DataSourceInfo;
import org.objectstyle.cayenne.project.ProjectDataSource;

public class ProjectDataSourceFactory
extends DriverDataSourceFactory {
    private static Logger logObj = Logger.getLogger(ProjectDataSourceFactory.class);
    protected File projectDir;

    public ProjectDataSourceFactory(File projectDir) throws Exception {
        this.projectDir = projectDir;
    }

    public DataSource getDataSource(String location) throws Exception {
        try {
            this.load(location);
        }
        catch (ConfigurationException e) {
            logObj.info("No data source at '" + location + "', ignoring.");
        }
        return new ProjectDataSource(this.getDriverInfo());
    }

    protected DataSourceInfo getDriverInfo() {
        DataSourceInfo temp = super.getDriverInfo();
        if (null == temp) {
            temp = new DataSourceInfo();
        }
        return temp;
    }
}

