/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.Iterator;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class DataMapValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DataMap map = (DataMap)path.getObject();
        this.validateName(map, path, validator);
        this.validateNodeLinks(map, path, validator);
    }

    protected void validateNodeLinks(DataMap map, ProjectPath path, Validator validator) {
        DataDomain domain = (DataDomain)path.getObjectParent();
        if (domain == null) {
            return;
        }
        boolean unlinked = true;
        int nodeCount = 0;
        Iterator it = domain.getDataNodes().iterator();
        while (it.hasNext()) {
            DataNode node = (DataNode)it.next();
            ++nodeCount;
            if (!node.getDataMaps().contains(map)) continue;
            unlinked = false;
            break;
        }
        if (unlinked && nodeCount > 0) {
            validator.registerWarning("DataMap is not linked to any DataNodes.", path);
        }
    }

    protected void validateName(DataMap map, ProjectPath path, Validator validator) {
        String name = map.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed DataMap.", path);
            return;
        }
        DataDomain domain = (DataDomain)path.getObjectParent();
        if (domain == null) {
            return;
        }
        Iterator it = domain.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap otherMap = (DataMap)it.next();
            if (otherMap == map || !name.equals(otherMap.getName())) continue;
            validator.registerError("Duplicate DataMap name: " + name + ".", path);
            return;
        }
    }
}

