/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.MappingNamesHelper;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class ObjAttributeValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        ObjAttribute attribute = (ObjAttribute)path.getObject();
        if (path.getObjectParent() != null && path.getObjectParent() != attribute.getEntity()) {
            return;
        }
        if (Util.isEmptyString(attribute.getName())) {
            validator.registerError("Unnamed ObjAttribute.", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInObjPathComponent(attribute.getName());
            if (invalidChars != null) {
                validator.registerWarning("ObjAttribute name contains invalid characters: " + invalidChars, path);
            } else if (helper.invalidDataObjectProperty(attribute.getName())) {
                validator.registerWarning("ObjAttribute name is invalid: " + attribute.getName(), path);
            }
        }
        if (Util.isEmptyString(attribute.getType())) {
            validator.registerWarning("ObjAttribute has no type.", path);
        }
        if (attribute.getDbAttribute() == null) {
            validator.registerWarning("ObjAttribute has no DbAttribute mapping.", path);
        } else if (attribute.getDbAttribute().isPrimaryKey() && attribute.getDbAttribute().isGenerated()) {
            validator.registerWarning("ObjAttribute is mapped to a generated PK: " + attribute.getDbAttributeName(), path);
        }
    }
}

