/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.MappingNamesHelper;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class ObjRelationshipValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        ObjRelationship inverse;
        ObjRelationship rel = (ObjRelationship)path.getObject();
        if (path.getObjectParent() != null && path.getObjectParent() != rel.getSourceEntity()) {
            return;
        }
        if (Util.isEmptyString(rel.getName())) {
            validator.registerError("Unnamed ObjRelationship.", path);
        } else if (rel.getSourceEntity().getAttribute(rel.getName()) != null) {
            validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has the same name as one of ObjAttributes", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInObjPathComponent(rel.getName());
            if (invalidChars != null) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " name contains invalid characters: " + invalidChars, path);
            } else if (helper.invalidDataObjectProperty(rel.getName())) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " name is invalid.", path);
            }
        }
        if (rel.getTargetEntity() == null) {
            validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has no target entity.", path);
        } else {
            List dbRels = rel.getDbRelationships();
            if (dbRels.size() == 0) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has no DbRelationship mapping.", path);
            } else {
                DbEntity expectedSrc = ((ObjEntity)rel.getSourceEntity()).getDbEntity();
                DbEntity expectedTarget = ((ObjEntity)rel.getTargetEntity()).getDbEntity();
                if (((DbRelationship)dbRels.get(0)).getSourceEntity() != expectedSrc || ((DbRelationship)dbRels.get(dbRels.size() - 1)).getTargetEntity() != expectedTarget) {
                    validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has incomplete DbRelationship mapping.", path);
                }
            }
        }
        if (rel.isToMany() && !rel.isFlattened() && rel.getDeleteRule() == 1 && (inverse = rel.getReverseRelationship()) != null) {
            DbRelationship firstRel = (DbRelationship)inverse.getDbRelationships().get(0);
            Iterator attributePairIterator = firstRel.getJoins().iterator();
            boolean check = true;
            while (attributePairIterator.hasNext()) {
                DbJoin pair = (DbJoin)attributePairIterator.next();
                if (pair.getSource().isMandatory()) continue;
                check = false;
                break;
            }
            if (check) {
                validator.registerWarning("ObjRelationship " + this.objRelationshipIdentifier(rel) + " has a Nullify delete rule and a mandatory reverse relationship ", path);
            }
        }
    }

    public String objRelationshipIdentifier(ObjRelationship rel) {
        if (null == rel.getSourceEntity()) {
            return "<[null source entity]." + rel.getName() + ">";
        }
        return "<" + rel.getSourceEntity().getName() + "." + rel.getName() + ">";
    }
}

