/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import org.apache.log4j.Logger;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.map.ProcedureParameter;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.DataMapValidator;
import org.objectstyle.cayenne.project.validator.DataNodeValidator;
import org.objectstyle.cayenne.project.validator.DbAttributeValidator;
import org.objectstyle.cayenne.project.validator.DbEntityValidator;
import org.objectstyle.cayenne.project.validator.DbRelationshipValidator;
import org.objectstyle.cayenne.project.validator.DomainValidator;
import org.objectstyle.cayenne.project.validator.ObjAttributeValidator;
import org.objectstyle.cayenne.project.validator.ObjEntityValidator;
import org.objectstyle.cayenne.project.validator.ObjRelationshipValidator;
import org.objectstyle.cayenne.project.validator.ProcedureParameterValidator;
import org.objectstyle.cayenne.project.validator.ProcedureQueryValidator;
import org.objectstyle.cayenne.project.validator.ProcedureValidator;
import org.objectstyle.cayenne.project.validator.SQLTemplateValidator;
import org.objectstyle.cayenne.project.validator.SelectQueryValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.SQLTemplate;
import org.objectstyle.cayenne.query.SelectQuery;

public abstract class TreeNodeValidator {
    private static Logger logObj = Logger.getLogger(TreeNodeValidator.class);
    protected static final DomainValidator domainValidator = new DomainValidator();
    protected static final DataNodeValidator nodeValidator = new DataNodeValidator();
    protected static final DataMapValidator mapValidator = new DataMapValidator();
    protected static final ObjEntityValidator objEntityValidator = new ObjEntityValidator();
    protected static final ObjAttributeValidator objAttrValidator = new ObjAttributeValidator();
    protected static final ObjRelationshipValidator objRelValidator = new ObjRelationshipValidator();
    protected static final DbEntityValidator dbEntityValidator = new DbEntityValidator();
    protected static final DbAttributeValidator dbAttrValidator = new DbAttributeValidator();
    protected static final DbRelationshipValidator dbRelValidator = new DbRelationshipValidator();
    protected static final ProcedureValidator procedureValidator = new ProcedureValidator();
    protected static final ProcedureParameterValidator procedureParameterValidator = new ProcedureParameterValidator();
    protected static final SelectQueryValidator selectQueryValidator = new SelectQueryValidator();
    protected static final ProcedureQueryValidator procedureQueryValidator = new ProcedureQueryValidator();
    protected static final SQLTemplateValidator sqlTemplateValidator = new SQLTemplateValidator();

    public static void validate(ProjectPath path, Validator validator) {
        Object validatedObj = path.getObject();
        TreeNodeValidator validatorObj = null;
        if (validatedObj instanceof ObjAttribute) {
            validatorObj = objAttrValidator;
        } else if (validatedObj instanceof ObjRelationship) {
            validatorObj = objRelValidator;
        } else if (validatedObj instanceof ObjEntity) {
            validatorObj = objEntityValidator;
        } else if (validatedObj instanceof DbAttribute) {
            validatorObj = dbAttrValidator;
        } else if (validatedObj instanceof DbRelationship) {
            validatorObj = dbRelValidator;
        } else if (validatedObj instanceof DbEntity) {
            validatorObj = dbEntityValidator;
        } else if (validatedObj instanceof DataNode) {
            validatorObj = nodeValidator;
        } else if (validatedObj instanceof DataMap) {
            validatorObj = mapValidator;
        } else if (validatedObj instanceof DataDomain) {
            validatorObj = domainValidator;
        } else if (validatedObj instanceof Procedure) {
            validatorObj = procedureValidator;
        } else if (validatedObj instanceof ProcedureParameter) {
            validatorObj = procedureParameterValidator;
        } else if (validatedObj instanceof SelectQuery) {
            validatorObj = selectQueryValidator;
        } else if (validatedObj instanceof SQLTemplate) {
            validatorObj = sqlTemplateValidator;
        } else if (validatedObj instanceof ProcedureQuery) {
            validatorObj = procedureQueryValidator;
        } else {
            String className = validatedObj != null ? validatedObj.getClass().getName() : "(null object)";
            logObj.info("Validation not supported for object of class: " + className);
            return;
        }
        ((TreeNodeValidator)validatorObj).validateObject(path, validator);
    }

    public abstract void validateObject(ProjectPath var1, Validator var2);
}

