/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.conf.ConfigStatus;
import org.objectstyle.cayenne.project.Project;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.ValidationInfo;

public class Validator {
    protected Project project;
    protected List validationResults = new ArrayList();
    protected int maxSeverity;

    public Validator(Project project) {
        this.project = project;
    }

    public Validator(Project project, ConfigStatus status) {
        this(project);
        if (status.hasFailures()) {
            ProjectPath path = new ProjectPath(project);
            Iterator<Object> it = status.getOtherFailures().iterator();
            while (it.hasNext()) {
                this.registerError((String)it.next(), path);
            }
            it = status.getFailedMaps().keySet().iterator();
            while (it.hasNext()) {
                this.registerError("Map failed to load: " + it.next(), path);
            }
            it = status.getFailedAdapters().keySet().iterator();
            while (it.hasNext()) {
                this.registerError("Adapter failed to load: " + it.next(), path);
            }
            it = status.getFailedDataSources().keySet().iterator();
            while (it.hasNext()) {
                this.registerError("DataSource failed to load: " + it.next(), path);
            }
            it = status.getFailedMapRefs().iterator();
            while (it.hasNext()) {
                this.registerError("Map reference failed to load: " + it.next(), path);
            }
        }
    }

    public Project getProject() {
        return this.project;
    }

    protected void reset() {
        if (this.validationResults != null) {
            this.validationResults = new ArrayList();
        }
        this.maxSeverity = 0;
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    public void registerValidated(int severity, String message, ProjectPath treeNodePath) {
        ValidationInfo result = new ValidationInfo(severity, message, treeNodePath);
        this.validationResults.add(result);
        if (this.maxSeverity < severity) {
            this.maxSeverity = severity;
        }
    }

    public void registerError(String message, ProjectPath treeNodePath) {
        this.registerValidated(2, message, treeNodePath);
    }

    public void registerWarning(String message, ProjectPath treeNodePath) {
        this.registerValidated(1, message, treeNodePath);
    }

    public List validationResults() {
        return this.validationResults;
    }

    public synchronized int validate() {
        return this.validate(this.project.treeNodes());
    }

    public synchronized int validate(Iterator treeNodes) {
        this.reset();
        while (treeNodes.hasNext()) {
            TreeNodeValidator.validate((ProjectPath)treeNodes.next(), this);
        }
        return this.getMaxSeverity();
    }
}

