/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Procedure;
import org.objectstyle.cayenne.query.BaseQueryMetadata;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.QueryRouter;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SQLActionVisitor;

public abstract class AbstractQuery
implements Query {
    protected Object root;
    protected String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        BaseQueryMetadata md = new BaseQueryMetadata();
        md.resolve(this.getRoot(), resolver, this.getName());
        return md;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object value) {
        if (value == null) {
            this.root = null;
        }
        if (!(value instanceof String || value instanceof ObjEntity || value instanceof DbEntity || value instanceof Class || value instanceof Procedure || value instanceof DataMap)) {
            String rootClass = value != null ? value.getClass().getName() : "null";
            throw new IllegalArgumentException(this.getClass().getName() + ": \"setRoot(..)\" takes a DataMap, String, ObjEntity, DbEntity, Procedure, " + "or Class. It was passed a " + rootClass);
        }
        this.root = value;
    }

    public String toString() {
        return new ToStringBuilder(this).append("root", this.root).append("name", this.getName()).toString();
    }

    public abstract SQLAction createSQLAction(SQLActionVisitor var1);

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        DataMap map = this.getMetaData(resolver).getDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap found, can't route query " + this);
        }
        router.route(router.engineForDataMap(map), this, substitutedQuery);
    }
}

