/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.query.BatchQuery;

public class UpdateBatchQuery
extends BatchQuery {
    protected List objectIds;
    protected List qualifierSnapshots;
    protected List updateSnapshots;
    protected boolean usingOptimisticLocking;
    private List updatedAttributes;
    private List qualifierAttributes;
    private Collection nullQualifierNames;
    private List dbAttributes;

    public UpdateBatchQuery(DbEntity dbEntity, List qualifierAttributes, List updatedAttribute, Collection nullQualifierNames, int batchCapacity) {
        super(dbEntity);
        this.updatedAttributes = updatedAttribute;
        this.qualifierAttributes = qualifierAttributes;
        this.nullQualifierNames = nullQualifierNames != null ? nullQualifierNames : Collections.EMPTY_SET;
        this.qualifierSnapshots = new ArrayList(batchCapacity);
        this.updateSnapshots = new ArrayList(batchCapacity);
        this.objectIds = new ArrayList(batchCapacity);
        this.dbAttributes = new ArrayList(this.updatedAttributes.size() + qualifierAttributes.size());
        this.dbAttributes.addAll(this.updatedAttributes);
        this.dbAttributes.addAll(qualifierAttributes);
    }

    public boolean isNull(DbAttribute attribute) {
        return this.nullQualifierNames.contains(attribute.getName());
    }

    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    public void setUsingOptimisticLocking(boolean usingOptimisticLocking) {
        this.usingOptimisticLocking = usingOptimisticLocking;
    }

    public Object getValue(int dbAttributeIndex) {
        DbAttribute attribute = (DbAttribute)this.dbAttributes.get(dbAttributeIndex);
        Object snapshot = dbAttributeIndex < this.updatedAttributes.size() ? this.updateSnapshots.get(this.batchIndex) : this.qualifierSnapshots.get(this.batchIndex);
        return this.getValue((Map)snapshot, attribute);
    }

    public void add(Map qualifierSnapshot, Map updateSnapshot) {
        this.add(qualifierSnapshot, updateSnapshot, null);
    }

    public void add(Map qualifierSnapshot, Map updateSnapshot, ObjectId id) {
        this.qualifierSnapshots.add(qualifierSnapshot);
        this.updateSnapshots.add(updateSnapshot);
        this.objectIds.add(id);
    }

    public int size() {
        return this.qualifierSnapshots.size();
    }

    public List getDbAttributes() {
        return this.dbAttributes;
    }

    public List getUpdatedAttributes() {
        return Collections.unmodifiableList(this.updatedAttributes);
    }

    public List getQualifierAttributes() {
        return Collections.unmodifiableList(this.qualifierAttributes);
    }

    public Map getCurrentQualifier() {
        return (Map)this.qualifierSnapshots.get(this.batchIndex);
    }

    public ObjectId getObjectId() {
        return (ObjectId)this.objectIds.get(this.batchIndex);
    }
}

