/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.property.CollectionProperty;
import org.objectstyle.cayenne.property.Property;
import org.objectstyle.cayenne.property.PropertyVisitor;
import org.objectstyle.cayenne.property.SingleObjectArcProperty;

public class DeepMergeOperation {
    protected ObjectContext context;
    protected Map seen;

    public DeepMergeOperation(ObjectContext context) {
        this.context = context;
        this.seen = new HashMap();
    }

    public void reset() {
        this.seen.clear();
    }

    public Object merge(Object object, ClassDescriptor descriptor) {
        if (!(object instanceof Persistent)) {
            throw new CayenneRuntimeException("Expected Persistent, got: " + object);
        }
        final Persistent source = (Persistent)object;
        ObjectId id = source.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: " + source);
        }
        Object seenTarget = this.seen.get(id);
        if (seenTarget != null) {
            return seenTarget;
        }
        final Persistent target = this.context.localObject(id, source);
        this.seen.put(id, target);
        descriptor = descriptor.getSubclassDescriptor(source.getClass());
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                if (!property.isFault(source)) {
                    Object destinationSource = property.readProperty(source);
                    Object destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge(destinationSource, property.getTargetDescriptor()) : null;
                    Object oldTarget = property.isFault(target) ? null : property.readProperty(target);
                    property.writeProperty(target, oldTarget, destinationTarget);
                }
                return true;
            }

            public boolean visitCollectionArc(CollectionProperty property) {
                if (!property.isFault(source)) {
                    Collection collection = (Collection)property.readProperty(source);
                    ArrayList<Object> targetCollection = new ArrayList<Object>(collection.size());
                    Iterator it = collection.iterator();
                    while (it.hasNext()) {
                        Object destinationSource = it.next();
                        Object destinationTarget = destinationSource != null ? DeepMergeOperation.this.merge(destinationSource, property.getTargetDescriptor()) : null;
                        targetCollection.add(destinationTarget);
                    }
                    property.writeProperty(target, null, targetCollection);
                }
                return true;
            }

            public boolean visitProperty(Property property) {
                return true;
            }
        });
        return target;
    }
}

