/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.wocompat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.wocompat.parser.Parser;

public class PropertyListSerialization {
    public static Object propertyListFromFile(File f) throws FileNotFoundException {
        if (!f.isFile()) {
            throw new FileNotFoundException("No such file: " + f);
        }
        return new Parser(f).propertyList();
    }

    public static Object propertyListFromStream(InputStream in) {
        return new Parser(in).propertyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propertyListToFile(File f, Object plist) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            try {
                PropertyListSerialization.writeObject("", out, plist);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error saving plist.", ioex);
        }
    }

    protected static void writeObject(String offset, Writer out, Object plist) throws IOException {
        if (plist == null) {
            return;
        }
        if (plist instanceof List) {
            List list = (List)plist;
            out.write(10);
            out.write(offset);
            if (list.size() == 0) {
                out.write("()");
                return;
            }
            out.write("(\n");
            String childOffset = offset + "   ";
            Iterator it = list.iterator();
            boolean appended = false;
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == null) continue;
                if (appended) {
                    out.write(", \n");
                }
                out.write(childOffset);
                PropertyListSerialization.writeObject(childOffset, out, obj);
                appended = true;
            }
            out.write(10);
            out.write(offset);
            out.write(41);
        } else if (plist instanceof Map) {
            Map map = (Map)plist;
            out.write(10);
            out.write(offset);
            if (map.size() == 0) {
                out.write("{}");
                return;
            }
            out.write("{");
            String childOffset = offset + "    ";
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Object obj;
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (key == null || (obj = entry.getValue()) == null) continue;
                out.write(10);
                out.write(childOffset);
                out.write(PropertyListSerialization.quoteString(key.toString()));
                out.write(" = ");
                PropertyListSerialization.writeObject(childOffset, out, obj);
                out.write(59);
            }
            out.write(10);
            out.write(offset);
            out.write(125);
        } else if (plist instanceof String) {
            out.write(PropertyListSerialization.quoteString(plist.toString()));
        } else if (plist instanceof Number) {
            out.write(plist.toString());
        } else {
            throw new CayenneRuntimeException("Unsupported class for property list serialization: " + plist.getClass().getName());
        }
    }

    protected static String escapeString(String str) {
        char[] chars = str.toCharArray();
        int len = chars.length;
        StringBuffer buf = new StringBuffer(len + 3);
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '\"' || chars[i] == '\\') {
                buf.append('\\');
            }
            buf.append(chars[i]);
        }
        return buf.toString();
    }

    protected static String quoteString(String str) {
        boolean shouldQuote = false;
        String noQuoteExtras = "_$:./";
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || noQuoteExtras.indexOf(c) >= 0) continue;
            shouldQuote = true;
            break;
        }
        str = PropertyListSerialization.escapeString(str);
        return shouldQuote ? '\"' + str + '\"' : str;
    }
}

