/*
 * Decompiled with CFR 0.152.
 */
package er.snapshotexplorer.model;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.snapshotexplorer.model.SEEntityStats;
import er.snapshotexplorer.model.SEModelStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEModelGroupStats {
    private EOModelGroup _modelGroup;
    private NSMutableDictionary<String, SEModelStats> _modelStats;

    public SEModelGroupStats(EOModelGroup modelGroup) {
        this._modelGroup = modelGroup;
    }

    public SEModelStats modelStatsForModelNamed(String modelName) {
        this.ensureModelsLoaded();
        return (SEModelStats)this._modelStats.objectForKey((Object)modelName);
    }

    public SEEntityStats entityStatsForEntityNamed(String entityName) {
        EOEntity entity = this._modelGroup.entityNamed(entityName);
        EOModel model = entity.model();
        SEModelStats modelStats = this.modelStatsForModelNamed(model.name());
        SEEntityStats entityStats = modelStats.entityStatsForEntityNamed(entityName);
        return entityStats;
    }

    public NSArray<SEModelStats> modelStats() {
        this.ensureModelsLoaded();
        return new NSArray(this._modelStats.values());
    }

    public int snapshotCount() {
        int snapshotCount = 0;
        for (SEModelStats modelStats : this.modelStats()) {
            snapshotCount += modelStats.snapshotCount();
        }
        return snapshotCount;
    }

    protected void ensureModelsLoaded() {
        if (this._modelStats == null) {
            this._modelStats = new NSMutableDictionary();
            for (EOModel model : this._modelGroup.models()) {
                SEModelStats modelStats = new SEModelStats(model);
                this._modelStats.setObjectForKey((Object)modelStats, (Object)model.name());
            }
        }
    }
}

