/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Response;
import com.silvasoftinc.s3.S3StreamObject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GetStreamResponse
extends Response {
    public S3StreamObject object;

    public GetStreamResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            Map metadata = this.extractMetadata(connection);
            this.object = new S3StreamObject(connection.getInputStream(), metadata);
        }
    }

    private Map extractMetadata(HttpURLConnection connection) {
        TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
        Map<String, List<String>> headers = connection.getHeaderFields();
        for (String key : headers.keySet()) {
            if (key == null || !key.startsWith("x-amz-meta-")) continue;
            metadata.put(key.substring("x-amz-meta-".length()), headers.get(key));
        }
        return metadata;
    }
}

