/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class QueryStringAuthGenerator {
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private Long expiresIn = null;
    private Long expires = null;
    private static final Long DEFAULT_EXPIRES_IN = new Long(60000L);

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public QueryStringAuthGenerator(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.expiresIn = DEFAULT_EXPIRES_IN;
        this.expires = null;
    }

    public void setExpires(long millisSinceEpoch) {
        this.expires = new Long(millisSinceEpoch);
        this.expiresIn = null;
    }

    public void setExpiresIn(long millis) {
        this.expiresIn = new Long(millis);
        this.expires = null;
    }

    public String createBucket(String bucket, Map headers) {
        return this.generateURL("PUT", bucket, headers);
    }

    public String listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map headers) {
        String path = Utils.pathForListOptions(bucket, prefix, marker, maxKeys);
        return this.generateURL("GET", path, headers);
    }

    public String deleteBucket(String bucket, Map headers) {
        return this.generateURL("DELETE", bucket, headers);
    }

    public String put(String bucket, String key, S3Object object, Map headers) {
        Map metadata = null;
        if (object != null) {
            metadata = object.metadata;
        }
        return this.generateURL("PUT", bucket + "/" + Utils.urlencode(key), this.mergeMeta(headers, metadata));
    }

    public String get(String bucket, String key, Map headers) {
        return this.generateURL("GET", bucket + "/" + Utils.urlencode(key), headers);
    }

    public String delete(String bucket, String key, Map headers) {
        return this.generateURL("DELETE", bucket + "/" + Utils.urlencode(key), headers);
    }

    public String getBucketACL(String bucket, Map headers) {
        return this.getACL(bucket, "", headers);
    }

    public String getACL(String bucket, String key, Map headers) {
        return this.generateURL("GET", bucket + "/" + Utils.urlencode(key) + "?acl", headers);
    }

    public String putBucketACL(String bucket, String aclXMLDoc, Map headers) {
        return this.putACL(bucket, "", aclXMLDoc, headers);
    }

    public String putACL(String bucket, String key, String aclXMLDoc, Map headers) {
        return this.generateURL("PUT", bucket + "/" + Utils.urlencode(key) + "?acl", headers);
    }

    public String listAllMyBuckets(Map headers) {
        return this.generateURL("GET", "", headers);
    }

    public String makeBareURL(String bucket, String key) {
        StringBuffer buffer = new StringBuffer();
        if (this.isSecure) {
            buffer.append("https://");
        } else {
            buffer.append("http://");
        }
        buffer.append(this.server).append(":").append(this.port).append("/").append(bucket);
        buffer.append("/").append(Utils.urlencode(key));
        return buffer.toString();
    }

    private String generateURL(String method, String path, Map headers) {
        long expires = 0L;
        if (this.expiresIn != null) {
            expires = System.currentTimeMillis() + this.expiresIn;
        } else if (this.expires != null) {
            expires = this.expires;
        } else {
            throw new RuntimeException("Illegal expires state");
        }
        String canonicalString = Utils.makeCanonicalString(method, path, headers, "" + (expires /= 1000L));
        String encodedCanonical = Utils.encode(this.awsSecretAccessKey, canonicalString, true);
        StringBuffer buffer = new StringBuffer();
        if (this.isSecure) {
            buffer.append("https://");
        } else {
            buffer.append("http://");
        }
        buffer.append(this.server).append(":").append(this.port).append("/").append(path);
        if (path.indexOf(63) == -1) {
            buffer.append("?");
        } else {
            buffer.append("&");
        }
        buffer.append("Signature=").append(encodedCanonical);
        buffer.append("&Expires=").append(expires);
        buffer.append("&AWSAccessKeyId=").append(this.awsAccessKeyId);
        return buffer.toString();
    }

    private Map mergeMeta(Map headers, Map metadata) {
        TreeMap merged = new TreeMap();
        if (headers != null) {
            for (String key : headers.keySet()) {
                merged.put(key, headers.get(key));
            }
        }
        if (metadata != null) {
            for (String key : metadata.keySet()) {
                String metadataKey = "x-amz-meta-" + key;
                if (merged.containsKey(metadataKey)) {
                    ((List)merged.get(metadataKey)).addAll((List)metadata.get(key));
                    continue;
                }
                merged.put(metadataKey, metadata.get(key));
            }
        }
        return merged;
    }
}

