/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegReader;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class JpegMetadataReader {
    public static Metadata readMetadata(InputStream in) throws JpegProcessingException {
        JpegSegmentReader segmentReader = new JpegSegmentReader(in);
        return JpegMetadataReader.extractJpegSegmentReaderMetadata(segmentReader);
    }

    public static Metadata readMetadata(File file) throws JpegProcessingException {
        JpegSegmentReader segmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractJpegSegmentReaderMetadata(segmentReader);
    }

    private static Metadata extractJpegSegmentReaderMetadata(JpegSegmentReader segmentReader) {
        Metadata metadata = new Metadata();
        try {
            byte[] exifSegment = segmentReader.readSegment((byte)-31);
            new ExifReader(exifSegment).extract(metadata);
        }
        catch (JpegProcessingException e) {
            // empty catch block
        }
        try {
            byte[] iptcSegment = segmentReader.readSegment((byte)-19);
            new IptcReader(iptcSegment).extract(metadata);
        }
        catch (JpegProcessingException e) {
            // empty catch block
        }
        try {
            byte[] jpegSegment = segmentReader.readSegment((byte)-64);
            new JpegReader(jpegSegment).extract(metadata);
        }
        catch (JpegProcessingException e) {
            // empty catch block
        }
        try {
            byte[] jpegCommentSegment = segmentReader.readSegment((byte)-2);
            new JpegCommentReader(jpegCommentSegment).extract(metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
        return metadata;
    }

    public static Metadata readMetadata(JPEGDecodeParam decodeParam) {
        byte[][] jpegCommentSegment;
        byte[][] iptcSegment;
        Metadata metadata = new Metadata();
        byte[][] exifSegment = decodeParam.getMarkerData(225);
        if (exifSegment != null && exifSegment[0].length > 0) {
            new ExifReader(exifSegment[0]).extract(metadata);
        }
        if ((iptcSegment = decodeParam.getMarkerData(237)) != null && iptcSegment[0].length > 0) {
            new IptcReader(iptcSegment[0]).extract(metadata);
        }
        if ((jpegCommentSegment = decodeParam.getMarkerData(254)) != null && jpegCommentSegment[0].length > 0) {
            new JpegCommentReader(jpegCommentSegment[0]).extract(metadata);
        }
        return metadata;
    }

    private JpegMetadataReader() {
    }

    public static void main(String[] args) throws MetadataException, IOException {
        Directory directory;
        JpegMetadataReader jpegReader = new JpegMetadataReader();
        Metadata metadata = null;
        try {
            metadata = JpegMetadataReader.readMetadata(new File(args[0]));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        Iterator directories = metadata.getDirectoryIterator();
        while (directories.hasNext()) {
            directory = (Directory)directories.next();
            Iterator tags = directory.getTagIterator();
            while (tags.hasNext()) {
                Tag tag = (Tag)tags.next();
                try {
                    System.out.println("[" + directory.getName() + "] " + tag.getTagName() + " = " + tag.getDescription());
                }
                catch (MetadataException e) {
                    System.err.println(e.getMessage());
                    System.err.println(tag.getDirectoryName() + " " + tag.getTagName() + " (error)");
                }
            }
            if (!directory.hasErrors()) continue;
            Iterator errors = directory.getErrors();
            while (errors.hasNext()) {
                System.out.println("ERROR: " + errors.next());
            }
        }
        if (args.length > 1 && args[1].trim().equals("/thumb")) {
            directory = (ExifDirectory)metadata.getDirectory(ExifDirectory.class);
            if (((ExifDirectory)directory).containsThumbnail()) {
                System.out.println("Writing thumbnail...");
                ((ExifDirectory)directory).writeThumbnail(args[0].trim() + ".thumb.jpg");
            } else {
                System.out.println("No thumbnail data exists in this image");
            }
        }
    }
}

