/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import java.text.DecimalFormat;

public class ExifDescriptor
extends TagDescriptor {
    private boolean _allowDecimalRepresentationOfRationals = true;

    public ExifDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 274: {
                return this.getOrientationDescription();
            }
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 33434: {
                return this.getExposureTimeDescription();
            }
            case 37377: {
                return this.getShutterSpeedDescription();
            }
            case 33437: {
                return this.getFNumberDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 513: {
                return this.getThumbnailOffsetDescription();
            }
            case 514: {
                return this.getThumbnailLengthDescription();
            }
            case 37122: {
                return this.getCompressionLevelDescription();
            }
            case 37382: {
                return this.getSubjectDistanceDescription();
            }
            case 37383: {
                return this.getMeteringModeDescription();
            }
            case 37384: {
                return this.getWhiteBalanceDescription();
            }
            case 37385: {
                return this.getFlashDescription();
            }
            case 37386: {
                return this.getFocalLengthDescription();
            }
            case 40961: {
                return this.getColorSpaceDescription();
            }
            case 40962: {
                return this.getExifImageWidthDescription();
            }
            case 40963: {
                return this.getExifImageHeightDescription();
            }
            case 41488: {
                return this.getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.getFocalPlaneYResolutionDescription();
            }
            case 256: {
                return this.getThumbnailImageWidthDescription();
            }
            case 257: {
                return this.getThumbnailImageHeightDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 259: {
                return this.getCompressionDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 34850: {
                return this.getExposureProgramDescription();
            }
            case 37378: {
                return this.getApertureValueDescription();
            }
            case 37381: {
                return this.getMaxApertureValueDescription();
            }
            case 41495: {
                return this.getSensingMethodDescription();
            }
            case 37380: {
                return this.getExposureBiasDescription();
            }
            case 41728: {
                return this.getFileSourceDescription();
            }
            case 41729: {
                return this.getSceneTypeDescription();
            }
            case 37121: {
                return this.getComponentConfigurationDescription();
            }
            case 36864: {
                return this.getExifVersionDescription();
            }
            case 40960: {
                return this.getFlashPixVersionDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
            case 34855: {
                return this.getIsoEquivalentDescription();
            }
            case 61441: {
                return this.getThumbnailDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    private String getThumbnailDescription() throws MetadataException {
        if (!this._directory.containsTag(61441)) {
            return null;
        }
        int[] thumbnailBytes = this._directory.getIntArray(61441);
        return "[" + thumbnailBytes.length + " bytes of thumbnail data]";
    }

    private String getIsoEquivalentDescription() throws MetadataException {
        if (!this._directory.containsTag(34855)) {
            return null;
        }
        int isoEquiv = this._directory.getInt(34855);
        if (isoEquiv < 50) {
            isoEquiv *= 200;
        }
        return Integer.toString(isoEquiv);
    }

    private String getReferenceBlackWhiteDescription() throws MetadataException {
        if (!this._directory.containsTag(532)) {
            return null;
        }
        int[] ints = this._directory.getIntArray(532);
        int blackR = ints[0];
        int whiteR = ints[1];
        int blackG = ints[2];
        int whiteG = ints[3];
        int blackB = ints[4];
        int whiteB = ints[5];
        String pos = "[" + blackR + "," + blackG + "," + blackB + "] " + "[" + whiteR + "," + whiteG + "," + whiteB + "]";
        return pos;
    }

    private String getExifVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(36864)) {
            return null;
        }
        int[] ints = this._directory.getIntArray(36864);
        return ExifDescriptor.convertBytesToVersionString(ints);
    }

    private String getFlashPixVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(40960)) {
            return null;
        }
        int[] ints = this._directory.getIntArray(40960);
        return ExifDescriptor.convertBytesToVersionString(ints);
    }

    private String getSceneTypeDescription() throws MetadataException {
        if (!this._directory.containsTag(41729)) {
            return null;
        }
        int sceneType = this._directory.getInt(41729);
        if (sceneType == 1) {
            return "Directly photographed image";
        }
        return "Unknown (" + sceneType + ")";
    }

    private String getFileSourceDescription() throws MetadataException {
        if (!this._directory.containsTag(41728)) {
            return null;
        }
        int fileSource = this._directory.getInt(41728);
        if (fileSource == 3) {
            return "Digital Still Camera (DSC)";
        }
        return "Unknown (" + fileSource + ")";
    }

    private String getExposureBiasDescription() throws MetadataException {
        if (!this._directory.containsTag(37380)) {
            return null;
        }
        Rational exposureBias = this._directory.getRational(37380);
        return exposureBias.toSimpleString(true);
    }

    private String getMaxApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(37381)) {
            return null;
        }
        double apertureApex = this._directory.getDouble(37381);
        double rootTwo = Math.sqrt(2.0);
        double fStop = Math.pow(rootTwo, apertureApex);
        DecimalFormat formatter = new DecimalFormat("0.#");
        return "F" + formatter.format(fStop);
    }

    private String getApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(37378)) {
            return null;
        }
        double apertureApex = this._directory.getDouble(37378);
        double rootTwo = Math.sqrt(2.0);
        double fStop = Math.pow(rootTwo, apertureApex);
        DecimalFormat formatter = new DecimalFormat("0.#");
        return "F" + formatter.format(fStop);
    }

    private String getExposureProgramDescription() throws MetadataException {
        if (!this._directory.containsTag(34850)) {
            return null;
        }
        switch (this._directory.getInt(34850)) {
            case 1: {
                return "Manual control";
            }
            case 2: {
                return "Program normal";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Program creative (slow program)";
            }
            case 6: {
                return "Program action (high-speed program)";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return "Unknown program (" + this._directory.getInt(34850) + ")";
    }

    private String getYCbCrSubsamplingDescription() throws MetadataException {
        if (!this._directory.containsTag(530)) {
            return null;
        }
        int[] positions = this._directory.getIntArray(530);
        if (positions[0] == 2 && positions[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (positions[0] == 2 && positions[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    private String getPlanarConfigurationDescription() throws MetadataException {
        if (!this._directory.containsTag(284)) {
            return null;
        }
        switch (this._directory.getInt(284)) {
            case 1: {
                return "Chunky (contiguous for each subsampling pixel)";
            }
            case 2: {
                return "Separate (Y-plane/Cb-plane/Cr-plane format)";
            }
        }
        return "Unknown configuration";
    }

    private String getSamplesPerPixelDescription() {
        if (!this._directory.containsTag(277)) {
            return null;
        }
        return this._directory.getString(277) + " samples/pixel";
    }

    private String getRowsPerStripDescription() {
        if (!this._directory.containsTag(278)) {
            return null;
        }
        return this._directory.getString(278) + " rows/strip";
    }

    private String getStripByteCountsDescription() {
        if (!this._directory.containsTag(279)) {
            return null;
        }
        return this._directory.getString(279) + " bytes";
    }

    private String getPhotometricInterpretationDescription() throws MetadataException {
        if (!this._directory.containsTag(262)) {
            return null;
        }
        switch (this._directory.getInt(262)) {
            case 1: {
                return "Monochrome";
            }
            case 2: {
                return "RGB";
            }
            case 6: {
                return "YCbCr";
            }
        }
        return "Unknown colour space";
    }

    private String getCompressionDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        switch (this._directory.getInt(259)) {
            case 1: {
                return "No compression";
            }
            case 6: {
                return "JPEG compression";
            }
        }
        return "Unknown compression";
    }

    private String getBitsPerSampleDescription() {
        if (!this._directory.containsTag(258)) {
            return null;
        }
        return this._directory.getString(258) + " bits/component/pixel";
    }

    private String getThumbnailImageWidthDescription() {
        if (!this._directory.containsTag(256)) {
            return null;
        }
        return this._directory.getString(256) + " pixels";
    }

    private String getThumbnailImageHeightDescription() {
        if (!this._directory.containsTag(257)) {
            return null;
        }
        return this._directory.getString(257) + " pixels";
    }

    private String getFocalPlaneXResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(41486)) {
            return null;
        }
        Rational rational = this._directory.getRational(41486);
        return rational.getReciprocal().toSimpleString(this._allowDecimalRepresentationOfRationals) + " " + this.getFocalPlaneResolutionUnitDescription().toLowerCase();
    }

    private String getFocalPlaneYResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        Rational rational = this._directory.getRational(41487);
        return rational.getReciprocal().toSimpleString(this._allowDecimalRepresentationOfRationals) + " " + this.getFocalPlaneResolutionUnitDescription().toLowerCase();
    }

    private String getFocalPlaneResolutionUnitDescription() throws MetadataException {
        if (!this._directory.containsTag(41488)) {
            return null;
        }
        switch (this._directory.getInt(41488)) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inches";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    private String getExifImageWidthDescription() throws MetadataException {
        if (!this._directory.containsTag(40962)) {
            return null;
        }
        return this._directory.getInt(40962) + " pixels";
    }

    private String getExifImageHeightDescription() throws MetadataException {
        if (!this._directory.containsTag(40963)) {
            return null;
        }
        return this._directory.getInt(40963) + " pixels";
    }

    private String getColorSpaceDescription() throws MetadataException {
        if (!this._directory.containsTag(40961)) {
            return null;
        }
        int colorSpace = this._directory.getInt(40961);
        if (colorSpace == 1) {
            return "sRGB";
        }
        if (colorSpace == 65535) {
            return "Undefined";
        }
        return "Unknown";
    }

    private String getFocalLengthDescription() throws MetadataException {
        if (!this._directory.containsTag(37386)) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        Rational focalLength = this._directory.getRational(37386);
        return formatter.format(focalLength.doubleValue()) + " mm";
    }

    private String getFlashDescription() throws MetadataException {
        if (!this._directory.containsTag(37385)) {
            return null;
        }
        switch (this._directory.getInt(37385)) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Flash fired";
            }
            case 5: {
                return "Flash fired but strobe return light not detected";
            }
            case 7: {
                return "flash fired and strobe return light detected";
            }
        }
        return "Unknown (" + this._directory.getInt(37385) + ")";
    }

    private String getWhiteBalanceDescription() throws MetadataException {
        if (!this._directory.containsTag(37384)) {
            return null;
        }
        switch (this._directory.getInt(37384)) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Flourescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 10: {
                return "Flash";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + this._directory.getInt(37384) + ")";
    }

    private String getMeteringModeDescription() throws MetadataException {
        if (!this._directory.containsTag(37383)) {
            return null;
        }
        int meteringMode = this._directory.getInt(37383);
        switch (meteringMode) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "";
    }

    private String getSubjectDistanceDescription() throws MetadataException {
        if (!this._directory.containsTag(37382)) {
            return null;
        }
        Rational distance = this._directory.getRational(37382);
        DecimalFormat formatter = new DecimalFormat("0.0##");
        return formatter.format(distance.doubleValue()) + " metres";
    }

    private String getCompressionLevelDescription() throws MetadataException {
        if (!this._directory.containsTag(37122)) {
            return null;
        }
        Rational compressionRatio = this._directory.getRational(37122);
        String ratio = compressionRatio.toSimpleString(this._allowDecimalRepresentationOfRationals);
        if (compressionRatio.isInteger() && compressionRatio.intValue() == 1) {
            return ratio + " bit/pixel";
        }
        return ratio + " bits/pixel";
    }

    private String getThumbnailLengthDescription() {
        if (!this._directory.containsTag(514)) {
            return null;
        }
        return this._directory.getString(514) + " bytes";
    }

    private String getThumbnailOffsetDescription() {
        if (!this._directory.containsTag(513)) {
            return null;
        }
        return this._directory.getString(513) + " bytes";
    }

    private String getYResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(283)) {
            return null;
        }
        Rational resolution = this._directory.getRational(283);
        return resolution.toSimpleString(this._allowDecimalRepresentationOfRationals) + " dots per " + this.getResolutionDescription().toLowerCase();
    }

    private String getXResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(282)) {
            return null;
        }
        Rational resolution = this._directory.getRational(282);
        return resolution.toSimpleString(this._allowDecimalRepresentationOfRationals) + " dots per " + this.getResolutionDescription().toLowerCase();
    }

    private String getExposureTimeDescription() {
        if (!this._directory.containsTag(33434)) {
            return null;
        }
        return this._directory.getString(33434) + " sec";
    }

    private String getShutterSpeedDescription() throws MetadataException {
        if (!this._directory.containsTag(37377)) {
            return null;
        }
        int apexValue = this._directory.getInt(37377);
        int apexPower = (int)Math.pow(2.0, apexValue);
        return "1/" + apexPower + " sec";
    }

    private String getFNumberDescription() throws MetadataException {
        if (!this._directory.containsTag(33437)) {
            return null;
        }
        Rational fNumber = this._directory.getRational(33437);
        DecimalFormat formatter = new DecimalFormat("0.#");
        return "F" + formatter.format(fNumber.doubleValue());
    }

    private String getYCbCrPositioningDescription() throws MetadataException {
        if (!this._directory.containsTag(531)) {
            return null;
        }
        int yCbCrPosition = this._directory.getInt(531);
        switch (yCbCrPosition) {
            case 1: {
                return "Center of pixel array";
            }
            case 2: {
                return "Datum point";
            }
        }
        return String.valueOf(yCbCrPosition);
    }

    private String getOrientationDescription() throws MetadataException {
        if (!this._directory.containsTag(274)) {
            return null;
        }
        int orientation = this._directory.getInt(274);
        switch (orientation) {
            case 1: {
                return "top, left side";
            }
            case 2: {
                return "top, right side";
            }
            case 3: {
                return "bottom, right side";
            }
            case 4: {
                return "bottom, left side";
            }
            case 5: {
                return "left side, top";
            }
            case 6: {
                return "right side, top";
            }
            case 7: {
                return "right side, bottom";
            }
            case 8: {
                return "left side, bottom";
            }
        }
        return String.valueOf(orientation);
    }

    private String getResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(296)) {
            return "";
        }
        int resolutionUnit = this._directory.getInt(296);
        switch (resolutionUnit) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inch";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    private String getSensingMethodDescription() throws MetadataException {
        if (!this._directory.containsTag(41495)) {
            return null;
        }
        int sensingMethod = this._directory.getInt(41495);
        switch (sensingMethod) {
            case 1: {
                return "(Not defined)";
            }
            case 2: {
                return "One-chip color area sensor";
            }
            case 3: {
                return "Two-chip color area sensor";
            }
            case 4: {
                return "Three-chip color area sensor";
            }
            case 5: {
                return "Color sequential area sensor";
            }
            case 7: {
                return "Trilinear sensor";
            }
            case 8: {
                return "Color sequential linear sensor";
            }
        }
        return "";
    }

    private String getComponentConfigurationDescription() throws MetadataException {
        int[] components = this._directory.getIntArray(37121);
        String[] componentStrings = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuffer componentConfig = new StringBuffer();
        for (int i = 0; i < Math.min(4, components.length); ++i) {
            int j = components[i];
            if (j <= 0 || j >= componentStrings.length) continue;
            componentConfig.append(componentStrings[j]);
        }
        return componentConfig.toString();
    }

    public static String convertBytesToVersionString(int[] components) {
        StringBuffer version = new StringBuffer();
        for (int i = 0; i < 4 && i < components.length; ++i) {
            if (i == 2) {
                version.append('.');
            }
            String digit = String.valueOf((char)components[i]);
            if (i == 0 && "0".equals(digit)) continue;
            version.append(digit);
        }
        return version.toString();
    }
}

