/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

public class ERMetadataEntry {
    private int _type;
    private String _name;
    private Object _value;
    private Class _dataType;

    public ERMetadataEntry(int type, String name, Object value, Class dataType) {
        this._type = type;
        this._name = name;
        this._value = value;
        this._dataType = dataType;
    }

    public Class getDataType() {
        return this._dataType;
    }

    public int getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public Object getValue() {
        return this._value;
    }

    public String getStringValue() {
        String value = this._value instanceof String ? (String)this._value : String.valueOf(this._value);
        return value.trim();
    }

    public int getIntValue(boolean firstWord) {
        int intValue;
        if (this._value instanceof Number) {
            intValue = ((Number)this._value).intValue();
        } else if (this._value instanceof String) {
            int spaceIndex;
            String valueStr = (String)this._value;
            if (firstWord && (spaceIndex = valueStr.indexOf(32)) != -1) {
                valueStr = valueStr.substring(0, spaceIndex);
            }
            intValue = Integer.parseInt(valueStr);
        } else {
            throw new IllegalArgumentException("Unable to convert value type " + this._value + " to an int.");
        }
        return intValue;
    }

    public boolean isValid() {
        return this._value != null && this.getStringValue().length() < 1024;
    }

    public String toString() {
        return "[MetadataEntry: type = " + this._type + "; name = " + this._name + "; value = " + this._value + "]";
    }

    public static boolean isValid(ERMetadataEntry entry) {
        return entry != null && entry.isValid();
    }
}

