/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import er.attachment.metadata.ERMetadataDirectorySet;
import er.attachment.metadata.ERMetadataEntry;
import er.attachment.metadata.ERMetadataUtils;
import er.attachment.metadata.ERParsedMetadataDirectory;
import er.attachment.metadata.IERMetadataParser;
import java.io.File;

public class ImageIOMetadataParser
implements IERMetadataParser {
    public ERMetadataDirectorySet parseMetadata(File importFile) {
        ERMetadataDirectorySet metadataDirectorySet = new ERMetadataDirectorySet();
        this.parseMetadata0(metadataDirectorySet, importFile.getAbsolutePath());
        return metadataDirectorySet;
    }

    protected void addMetadataEntry(ERMetadataDirectorySet metadataDirectorySet, String directoryName, String name, String value) {
        String internalDirectoryName;
        int type = -1;
        if ("{Exif}".equals(directoryName)) {
            internalDirectoryName = "EXIF";
            type = ERMetadataUtils.typeForExifTagName(name);
        } else if ("{IPTC}".equals(directoryName)) {
            internalDirectoryName = "IPTC";
            type = ERMetadataUtils.typeForIptcTagName(name);
        } else if ("{TIFF}".equals(directoryName)) {
            internalDirectoryName = "EXIF";
            type = ERMetadataUtils.typeForExifTagName(name);
        } else if ("{PDF}".equals(directoryName)) {
            internalDirectoryName = "PDF";
            type = ERMetadataUtils.typeForPdfTagName(name);
        } else {
            internalDirectoryName = directoryName;
        }
        ERParsedMetadataDirectory metadataDirectory = metadataDirectorySet.getDirectoryNamed(internalDirectoryName);
        if (metadataDirectory == null) {
            metadataDirectory = new ERParsedMetadataDirectory(internalDirectoryName);
            metadataDirectorySet.addMetadata(metadataDirectory);
        }
        if (type == -1) {
            type = name.hashCode();
        }
        metadataDirectory.addMetadataEntry(new ERMetadataEntry(type, name, value, ERMetadataUtils.classForTagName(internalDirectoryName, name)));
    }

    private native void parseMetadata0(ERMetadataDirectorySet var1, String var2);

    static {
        System.loadLibrary("ImageIOMetadataParser");
    }
}

