/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.metadata;

import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.iptc.IptcReader;
import er.attachment.metadata.DrewMetadataParser;
import er.attachment.metadata.ERMetadataDirectorySet;
import er.attachment.metadata.ERMetadataParserException;
import er.attachment.metadata.ERParsedMetadataDirectory;
import er.attachment.metadata.IERMetadataParser;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class JAIMetadataParser
implements IERMetadataParser {
    public static int EXIF = 225;
    public static int IPTC = 237;
    private static Set<String> UNWANTED = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERMetadataDirectorySet parseMetadata(File importFile) throws ERMetadataParserException {
        try {
            ERMetadataDirectorySet rawAssetMetadata = new ERMetadataDirectorySet();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(importFile);
            try {
                Iterator<ImageReader> imageReadersIter = ImageIO.getImageReaders(imageInputStream);
                while (imageReadersIter.hasNext()) {
                    ExifDirectory exifDirectory;
                    Node metadataTree;
                    ImageReader imageReader = imageReadersIter.next();
                    imageReader.setInput(imageInputStream);
                    rawAssetMetadata.setWidth(imageReader.getWidth(0));
                    rawAssetMetadata.setHeight(imageReader.getHeight(0));
                    IIOMetadata metadata = imageReader.getImageMetadata(0);
                    if (metadata == null || (metadataTree = metadata.getAsTree(metadata.getNativeMetadataFormatName())) == null) continue;
                    IptcDirectory iptcDirectory = this.getIptcDirectory(metadataTree);
                    if (iptcDirectory != null) {
                        ERParsedMetadataDirectory iptcMetadataDirectory = new ERParsedMetadataDirectory("IPTC");
                        DrewMetadataParser.fillInParsedMetadataDirectoryFromDrewMetadata(iptcMetadataDirectory, iptcDirectory);
                        rawAssetMetadata.addMetadata(iptcMetadataDirectory);
                    }
                    if ((exifDirectory = this.getExifDirectory(metadataTree)) == null) continue;
                    ERParsedMetadataDirectory exifMetadataDirectory = new ERParsedMetadataDirectory("EXIF");
                    DrewMetadataParser.fillInParsedMetadataDirectoryFromDrewMetadata(exifMetadataDirectory, exifDirectory);
                    rawAssetMetadata.addMetadata(exifMetadataDirectory);
                }
            }
            finally {
                imageInputStream.close();
            }
            return rawAssetMetadata;
        }
        catch (IOException e) {
            throw new ERMetadataParserException("Failed to parse metadata.", e);
        }
    }

    private ExifDirectory getExifDirectory(Node node) {
        if ("unknown".equals(node.getNodeName()) && Integer.parseInt(node.getAttributes().getNamedItem("MarkerTag").getNodeValue()) == EXIF) {
            byte[] data = (byte[])((IIOMetadataNode)node).getUserObject();
            return (ExifDirectory)new ExifReader(data).extract().getDirectory(ExifDirectory.class);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ExifDirectory directory = this.getExifDirectory(child);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    private IptcDirectory getIptcDirectory(Node node) {
        if ("unknown".equals(node.getNodeName()) && Integer.parseInt(node.getAttributes().getNamedItem("MarkerTag").getNodeValue()) == IPTC) {
            byte[] data = (byte[])((IIOMetadataNode)node).getUserObject();
            IptcDirectory iptcDirectory = (IptcDirectory)new IptcReader(data).extract().getDirectory(IptcDirectory.class);
            return iptcDirectory;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            IptcDirectory directory = this.getIptcDirectory(child);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    private String suffix(File file) {
        String s = file.getName();
        int i = s.lastIndexOf(46);
        return s.substring(i + 1);
    }

    static {
        UNWANTED.add("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader");
        UNWANTED.add("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter");
    }
}

