/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.model;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.QueryStringAuthGenerator;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import er.attachment.model._ERS3Attachment;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import org.apache.log4j.Logger;

public class ERS3Attachment
extends _ERS3Attachment {
    public static final String STORAGE_TYPE = "s3";
    private static Logger log = Logger.getLogger(ERS3Attachment.class);
    private File _pendingUploadFile;
    private boolean _pendingDelete;

    private boolean isInNestedEditingContext() {
        EOEditingContext attachmentEc = this.editingContext();
        return attachmentEc.parentObjectStore() instanceof EOEditingContext && ((EOEditingContext)attachmentEc.parentObjectStore()).objectForGlobalID(attachmentEc.globalIDForObject((EOEnterpriseObject)this)) != null;
    }

    public void _setPendingUploadFile(File pendingUploadFile, boolean pendingDelete) {
        this._pendingUploadFile = pendingUploadFile;
    }

    public File _pendingUploadFile() {
        return this._pendingUploadFile;
    }

    public boolean _isPendingDelete() {
        return this._pendingDelete;
    }

    public void didInsert() {
        super.didInsert();
        if (this.isInNestedEditingContext()) {
            EOEditingContext parentEditingContext = (EOEditingContext)this.editingContext().parentObjectStore();
            ((ERS3Attachment)parentEditingContext.objectForGlobalID(this.editingContext().globalIDForObject((EOEnterpriseObject)this)))._setPendingUploadFile(this._pendingUploadFile(), false);
        }
    }

    public void awakeFromInsertion(EOEditingContext ec) {
        super.awakeFromInsertion(ec);
        this.setStorageType(STORAGE_TYPE);
    }

    public void setS3Location(String bucket, String key) {
        this.setWebPath("/" + bucket + "/" + key);
    }

    public String bucket() {
        String[] paths = this.webPath().split("/");
        String bucket = paths[1];
        return bucket;
    }

    public String key() {
        String[] paths = this.webPath().split("/");
        String key = paths[2];
        return key;
    }

    public String s3Path() {
        String s3Path = super.s3Path();
        if ("private".equals(this.acl())) {
            QueryStringAuthGenerator q = this.queryStringAuthGenerator();
            q.setExpiresIn(this.linkLife().intValue());
            s3Path = q.get(this.bucket(), this.key(), null);
        }
        return s3Path;
    }

    public Integer linkLife() {
        String linkLife = ERXProperties.decryptedStringForKey((String)("er.attachment." + this.configurationName() + ".s3.linkLife"));
        if (linkLife == null) {
            linkLife = ERXProperties.decryptedStringForKey((String)"er.attachment.s3.linkLife");
        }
        if (linkLife == null) {
            linkLife = "60000";
        }
        return Integer.valueOf(linkLife);
    }

    public String accessKeyID() {
        String accessKeyID = ERXProperties.decryptedStringForKey((String)("er.attachment." + this.configurationName() + ".s3.accessKeyID"));
        if (accessKeyID == null) {
            accessKeyID = ERXProperties.decryptedStringForKey((String)"er.attachment.s3.accessKeyID");
        }
        if (accessKeyID == null) {
            throw new IllegalArgumentException("There is no 'er.attachment." + this.configurationName() + ".s3.accessKeyID' or 'er.attachment.s3.accessKeyID' property set.");
        }
        return accessKeyID;
    }

    public String secretAccessKey() {
        String secretAccessKey = ERXProperties.decryptedStringForKey((String)("er.attachment." + this.configurationName() + ".s3.secretAccessKey"));
        if (secretAccessKey == null) {
            secretAccessKey = ERXProperties.decryptedStringForKey((String)"er.attachment.s3.secretAccessKey");
        }
        if (secretAccessKey == null) {
            throw new IllegalArgumentException("There is no 'er.attachment." + this.configurationName() + ".s3.secretAccessKey' or 'er.attachment.s3.secretAccessKey' property set.");
        }
        return secretAccessKey;
    }

    public String acl() {
        String acl = ERXProperties.decryptedStringForKey((String)("er.attachment." + this.configurationName() + ".s3.acl"));
        if (acl == null) {
            acl = ERXProperties.decryptedStringForKey((String)"er.attachment.s3.acl");
        }
        if (acl == null) {
            acl = "public-read";
        }
        return acl;
    }

    public QueryStringAuthGenerator queryStringAuthGenerator() {
        return new QueryStringAuthGenerator(this.accessKeyID(), this.secretAccessKey(), false);
    }

    public AWSAuthConnection awsConnection() {
        AWSAuthConnection conn = new AWSAuthConnection(this.accessKeyID(), this.secretAccessKey(), true);
        return conn;
    }
}

