/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.processors;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSMutableDictionary;
import er.attachment.model.ERAttachment;
import er.attachment.model.ERPendingAttachment;
import er.attachment.model._ERAttachment;
import er.attachment.processors.ERDatabaseAttachmentProcessor;
import er.attachment.processors.ERFileAttachmentProcessor;
import er.attachment.processors.ERS3AttachmentProcessor;
import er.attachment.processors.IERAttachmentProcessorDelegate;
import er.attachment.thumbnail.ERThumbnailer;
import er.attachment.thumbnail.IERThumbnailer;
import er.attachment.utils.ERMimeType;
import er.attachment.utils.ERMimeTypeManager;
import er.extensions.crypting.ERXCrypto;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.validation.ERXValidationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERAttachmentProcessor<T extends ERAttachment> {
    public static final Logger log = Logger.getLogger(ERAttachmentProcessor.class);
    private static final String EXT_VARIABLE = "\\$\\{ext\\}";
    private static final String HASH_VARIABLE = "\\$\\{hash\\}";
    private static final String PK_VARIABLE = "\\$\\{pk\\}";
    private static final String FILE_NAME_VARIABLE = "\\$\\{fileName\\}";
    private static final String UUID_VARIABLE = "\\$\\{uuid\\}";
    private static NSMutableDictionary<String, ERAttachmentProcessor<?>> _processors;
    private IERAttachmentProcessorDelegate _delegate;

    public static synchronized NSMutableDictionary<String, ERAttachmentProcessor<?>> processors() {
        if (_processors == null) {
            _processors = new NSMutableDictionary();
            _processors.setObjectForKey((Object)new ERDatabaseAttachmentProcessor(), (Object)"db");
            _processors.setObjectForKey((Object)new ERS3AttachmentProcessor(), (Object)"s3");
            _processors.setObjectForKey((Object)new ERFileAttachmentProcessor(), (Object)"file");
        }
        return _processors;
    }

    public static <T extends ERAttachment> ERAttachmentProcessor<T> processorForType(T attachment) {
        return ERAttachmentProcessor.processorForType(attachment == null ? null : attachment.storageType());
    }

    public static <T extends ERAttachment> ERAttachmentProcessor<T> processorForType(String storageType) {
        ERAttachmentProcessor processor = (ERAttachmentProcessor)ERAttachmentProcessor.processors().objectForKey((Object)storageType);
        if (processor == null) {
            throw new IllegalArgumentException("There is no attachment processor for the type '" + storageType + "'.");
        }
        return processor;
    }

    public static <T extends ERAttachment> ERAttachmentProcessor<T> processorForConfigurationName(String configurationName) {
        String storageType = ERXProperties.stringForKey((String)("er.attachment." + configurationName + ".storageType"));
        if (storageType == null) {
            storageType = ERXProperties.stringForKeyWithDefault((String)"er.attachment.storageType", (String)"db");
        }
        return ERAttachmentProcessor.processorForType(storageType);
    }

    public static synchronized void addAttachmentProcessorForType(ERAttachmentProcessor<?> processor, String storageType) {
        ERAttachmentProcessor.processors().setObjectForKey(processor, (Object)storageType);
    }

    protected static String _parsePathTemplate(ERAttachment attachment, String templatePath, String recommendedFileName) {
        String parsedPath = templatePath;
        String ext = ERMimeTypeManager.primaryExtension(attachment.mimeType());
        if (ext == null) {
            ext = ERXFileUtilities.fileExtension((String)recommendedFileName);
        }
        parsedPath = ext != null ? parsedPath.replaceAll(EXT_VARIABLE, "." + ext) : parsedPath.replaceAll(EXT_VARIABLE, "");
        String filenameHash = ERXCrypto.shaEncode((String)recommendedFileName);
        StringBuffer hashPathBuffer = new StringBuffer();
        hashPathBuffer.append(filenameHash.charAt(0));
        hashPathBuffer.append('/');
        hashPathBuffer.append(filenameHash.charAt(1));
        hashPathBuffer.append('/');
        hashPathBuffer.append(filenameHash.charAt(2));
        parsedPath = parsedPath.replaceAll(HASH_VARIABLE, hashPathBuffer.toString());
        parsedPath = parsedPath.replaceAll(UUID_VARIABLE, UUID.randomUUID().toString());
        parsedPath = parsedPath.replaceAll(FILE_NAME_VARIABLE, recommendedFileName);
        parsedPath = parsedPath.replaceAll(PK_VARIABLE, attachment.primaryKeyInTransaction());
        return parsedPath;
    }

    public void setDelegate(IERAttachmentProcessorDelegate delegate) {
        this._delegate = delegate;
    }

    public IERAttachmentProcessorDelegate delegate() {
        return this._delegate;
    }

    protected String proxiedUrl(T attachment, WOContext context) {
        String webPath = ((_ERAttachment)((Object)attachment)).webPath();
        if (webPath.startsWith("/")) {
            webPath = webPath.substring(1);
        }
        webPath = "id/" + attachment.primaryKey() + "/" + webPath;
        String attachmentUrl = context.urlWithRequestHandlerKey("attachments", webPath, null);
        return attachmentUrl;
    }

    public T process(EOEditingContext editingContext, File uploadedFile) throws IOException {
        ERPendingAttachment pendingAttachment = new ERPendingAttachment(uploadedFile, uploadedFile.getName(), null, null, null);
        pendingAttachment.setPendingDelete(false);
        return this.process(editingContext, pendingAttachment);
    }

    public T process(EOEditingContext editingContext, File uploadedFile, String recommendedFilePath) throws IOException {
        return this.process(editingContext, new ERPendingAttachment(uploadedFile, recommendedFilePath, null, null, null));
    }

    public T process(EOEditingContext editingContext, File uploadedFile, String recommendedFilePath, String mimeType) throws IOException {
        return this.process(editingContext, new ERPendingAttachment(uploadedFile, recommendedFilePath, mimeType, null, null));
    }

    public T process(EOEditingContext editingContext, File uploadedFile, String recommendedFilePath, String mimeType, String configurationName, String ownerID) throws IOException {
        return this.process(editingContext, new ERPendingAttachment(uploadedFile, recommendedFilePath, mimeType, configurationName, ownerID));
    }

    public T process(EOEditingContext editingContext, File uploadedFile, String recommendedFilePath, String mimeType, int width, int height, String configurationName, String ownerID) throws IOException {
        return this.process(editingContext, new ERPendingAttachment(uploadedFile, recommendedFilePath, mimeType, width, height, configurationName, ownerID));
    }

    public T process(EOEditingContext editingContext, ERPendingAttachment pendingAttachment) throws IOException {
        IERThumbnailer thumbnailer;
        ERMimeType mimeType;
        ERMimeType erMimeType;
        File uploadedFile = pendingAttachment.uploadedFile();
        String recommendedFileName = pendingAttachment.recommendedFileName();
        String configurationName = pendingAttachment.configurationName();
        long maxSize = ERXProperties.longForKey((String)("er.attachment." + configurationName + ".maxSize"));
        if (maxSize == 0L) {
            maxSize = ERXProperties.longForKeyWithDefault((String)"er.attachment.maxSize", (long)0L);
        }
        if (maxSize > 0L && uploadedFile.length() > maxSize) {
            if (pendingAttachment.isPendingDelete()) {
                uploadedFile.delete();
            }
            ERXAttachmentExceedsLengthException maxSizeExceededException = new ERXAttachmentExceedsLengthException("AttachmentExceedsMaximumLengthException", uploadedFile, "size", maxSize, recommendedFileName);
            throw maxSizeExceededException;
        }
        String suggestedMimeType = pendingAttachment.mimeType();
        if (suggestedMimeType != null && (erMimeType = ERMimeTypeManager.mimeTypeManager().mimeTypeForMimeTypeString(suggestedMimeType, false)) == null) {
            suggestedMimeType = null;
        }
        if (suggestedMimeType == null) {
            String extension = ERXFileUtilities.fileExtension((String)recommendedFileName);
            ERMimeType erMimeType2 = ERMimeTypeManager.mimeTypeManager().mimeTypeForExtension(extension, false);
            if (erMimeType2 != null) {
                suggestedMimeType = erMimeType2.mimeType();
            }
            if (suggestedMimeType == null) {
                suggestedMimeType = "application/x-octet-stream";
            }
        }
        int width = pendingAttachment.width();
        int height = pendingAttachment.height();
        if ((width != -1 || height != -1) && (mimeType = ERMimeTypeManager.mimeTypeManager().mimeTypeForMimeTypeString(suggestedMimeType, false)) != null && (thumbnailer = ERThumbnailer.thumbnailer(mimeType)) != null) {
            thumbnailer.thumbnail(width, height, uploadedFile, uploadedFile, mimeType);
        }
        String ownerID = pendingAttachment.ownerID();
        T attachment = this._process(editingContext, uploadedFile, recommendedFileName, suggestedMimeType, configurationName, ownerID, pendingAttachment.isPendingDelete());
        ((_ERAttachment)((Object)attachment)).setConfigurationName(configurationName);
        ((_ERAttachment)((Object)attachment)).setOwnerID(ownerID);
        return attachment;
    }

    public void attachmentInserted(T attachment) {
    }

    public boolean proxyAsAttachment(T attachment) {
        boolean proxyAsAttachment = false;
        String proxyAsAttachmentStr = ERXProperties.stringForKey((String)("er.attachment." + ((_ERAttachment)((Object)attachment)).configurationName() + ".proxyAsAttachment"));
        if (proxyAsAttachmentStr == null) {
            proxyAsAttachmentStr = ERXProperties.stringForKey((String)"er.attachment.proxyAsAttachment");
        }
        if (proxyAsAttachmentStr != null) {
            proxyAsAttachment = Boolean.parseBoolean(proxyAsAttachmentStr);
        }
        return proxyAsAttachment;
    }

    public abstract T _process(EOEditingContext var1, File var2, String var3, String var4, String var5, String var6, boolean var7) throws IOException;

    public abstract InputStream attachmentInputStream(T var1) throws IOException;

    public abstract String attachmentUrl(T var1, WORequest var2, WOContext var3);

    public abstract void deleteAttachment(T var1) throws IOException;

    public static class ERXAttachmentExceedsLengthException
    extends ERXValidationException {
        private long _maxSize;
        private String _recommendedFileName;

        public ERXAttachmentExceedsLengthException(String type, Object object, String key, long maxSize, String recommendedFileName) {
            super(type, object, key);
            this._maxSize = maxSize;
            this._recommendedFileName = recommendedFileName;
        }

        public void setMaxSize(long maxSize) {
            this._maxSize = maxSize;
        }

        public long getMaxSize() {
            return this._maxSize;
        }

        public void setRecommendedFileName(String recommendedFileName) {
            this._recommendedFileName = recommendedFileName;
        }

        public String getRecommendedFileName() {
            return this._recommendedFileName;
        }
    }
}

