/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.thumbnail;

import er.attachment.thumbnail.ERImageProcessor;
import er.attachment.thumbnail.IERImageProcessor;
import er.attachment.utils.ERMimeType;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRuntimeUtilities;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class ImageMagickImageProcessor
extends ERImageProcessor {
    private File _imageMagickConvertBinary;
    private File _imageMagickCompositeBinary;
    private long _maxMemory;

    public ImageMagickImageProcessor(File imageMagickConvertBinary, File imageMagickCompositeBinary) {
        this(imageMagickConvertBinary, imageMagickCompositeBinary, 128000000L);
    }

    public ImageMagickImageProcessor(File imageMagickConvertBinary, File imageMagickCompositeBinary, long maxMemory) {
        this._imageMagickConvertBinary = imageMagickConvertBinary;
        this._imageMagickCompositeBinary = imageMagickCompositeBinary;
        this._maxMemory = maxMemory;
    }

    public void processImage(int resizeWidth, int resizeHeight, IERImageProcessor.Quality resizeQuality, int dpi, float sharpenRadius, float sharpenIntensity, float gamma, int cropX, int cropY, int cropWidth, int cropHeight, File watermarkFile, boolean tileWatermark, float compressionQuality, File colorProfileFile, File inputFile, File outputFile, ERMimeType outputMimeType) throws IOException {
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new IOException("Failed to create folder '" + outputFile.getParentFile() + "'.");
        }
        LinkedList<String> imageMagickCommandList = new LinkedList<String>();
        imageMagickCommandList.add(this._imageMagickConvertBinary.getAbsolutePath());
        imageMagickCommandList.add("-limit");
        imageMagickCommandList.add("Memory");
        imageMagickCommandList.add(String.valueOf(this._maxMemory));
        String resizeString = null;
        if (resizeWidth != -1 && resizeHeight != -1) {
            resizeString = resizeWidth + "x" + resizeHeight;
        } else if (resizeWidth != -1) {
            resizeString = resizeWidth + "x";
        } else if (resizeHeight != -1) {
            resizeString = "x" + resizeHeight;
        }
        if (resizeString != null) {
            imageMagickCommandList.add("-size");
            imageMagickCommandList.add(resizeString);
            if (resizeQuality == IERImageProcessor.Quality.Low) {
                imageMagickCommandList.add("-sample");
            } else if (resizeQuality == IERImageProcessor.Quality.Medium) {
                imageMagickCommandList.add("-scale");
            } else {
                imageMagickCommandList.add("-resize");
            }
            imageMagickCommandList.add(resizeString);
        }
        if ((double)dpi > 0.0) {
            imageMagickCommandList.add("-density");
            imageMagickCommandList.add(dpi + "x" + dpi);
        }
        if (cropWidth > 0 || cropHeight > 0) {
            imageMagickCommandList.add("-crop");
            imageMagickCommandList.add(cropWidth + "x" + cropHeight + "+" + cropX + "+" + cropY);
        }
        if (colorProfileFile != null) {
            imageMagickCommandList.add("-profile");
            imageMagickCommandList.add(colorProfileFile.getAbsolutePath());
        }
        if ((double)sharpenRadius > 0.0) {
            imageMagickCommandList.add("-unsharp");
            imageMagickCommandList.add(sharpenRadius + "x1+" + sharpenIntensity + "+6");
        }
        if ((double)gamma > 0.0) {
            imageMagickCommandList.add("-gamma");
            imageMagickCommandList.add(String.valueOf(gamma));
        }
        if ((double)compressionQuality > 0.0) {
            imageMagickCommandList.add("-quality");
            imageMagickCommandList.add(String.valueOf((int)(compressionQuality * 100.0f)));
        }
        imageMagickCommandList.add(inputFile.getAbsolutePath() + "[0]");
        imageMagickCommandList.add(outputFile.getAbsolutePath());
        String[] imageMagickCommands = imageMagickCommandList.toArray(new String[imageMagickCommandList.size()]);
        try {
            System.out.println("ImageMagickProcessor.processImage: " + imageMagickCommandList);
            ERXRuntimeUtilities.Result result = ERXRuntimeUtilities.execute((String[])imageMagickCommands, null, null, (long)0L);
            int exitValue = result.getExitValue();
            if (exitValue != 0) {
                log.warn((Object)("Warning: ImageMagick convert returned with a value of " + exitValue + ", error = " + result.getErrorAsString()));
            }
        }
        catch (Exception e) {
            IOException ioex = new IOException("ImageMagick failed.");
            ioex.initCause(e);
            throw ioex;
        }
        if (watermarkFile != null) {
            LinkedList<String> watermarkCommandList = new LinkedList<String>();
            watermarkCommandList.add(this._imageMagickCompositeBinary.getAbsolutePath());
            watermarkCommandList.add("-compose");
            watermarkCommandList.add("screen");
            if (tileWatermark) {
                watermarkCommandList.add("-tile");
            }
            watermarkCommandList.add(watermarkFile.getAbsolutePath());
            watermarkCommandList.add(outputFile.getAbsolutePath());
            watermarkCommandList.add(outputFile.getAbsolutePath());
            try {
                ERXRuntimeUtilities.Result result = ERXRuntimeUtilities.execute((String[])imageMagickCommands, null, null, (long)0L);
                int exitValue = result.getExitValue();
                if (exitValue != 0) {
                    log.warn((Object)("Warning: ImageMagick composite returned with a value of " + exitValue + ", error = " + result.getErrorAsString()));
                }
            }
            catch (Exception e) {
                IOException ioex = new IOException("ImageMagick was interrupted.");
                ioex.initCause(e);
                throw ioex;
            }
        }
        if (!outputFile.exists()) {
            throw new IOException("Failed to process image '" + inputFile + "' into '" + outputFile + "'.");
        }
    }

    public static IERImageProcessor imageMagickImageProcessor() throws IOException {
        File imageMagickCompositeFile;
        File imageMagickConvertFile;
        ImageMagickImageProcessor imageProcessor = null;
        String imageMagickBinFolder = ERXProperties.stringForKey((String)"er.attachment.ImageProcessor.imageMagickBinFolder");
        if (imageMagickBinFolder != null) {
            imageMagickConvertFile = new File(imageMagickBinFolder, "convert");
            imageMagickCompositeFile = new File(imageMagickBinFolder, "composite");
            if (!imageMagickConvertFile.exists() || !imageMagickCompositeFile.exists()) {
                throw new IllegalArgumentException("Cannot use ImageMagick because either " + imageMagickConvertFile + " or " + imageMagickCompositeFile + " does not exist.");
            }
        } else {
            throw new IllegalArgumentException("Cannot use ImageMagick because you have not set 'er.attachment.ImageProcessor.imageMagickBinFolder'.");
        }
        imageProcessor = new ImageMagickImageProcessor(imageMagickConvertFile, imageMagickCompositeFile);
        return imageProcessor;
    }
}

