/*
 * Decompiled with CFR 0.152.
 */
package er.attachment.utils;

import com.webobjects.foundation.NSArray;
import er.attachment.utils.ERGlobMimeType;
import er.attachment.utils.ERMimeType;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class ERMimeTypeManager {
    private static ERMimeTypeManager INSTANCE;
    private List<ERMimeType> _mimeTypes = new LinkedList<ERMimeType>();

    public static synchronized ERMimeTypeManager mimeTypeManager() {
        if (INSTANCE == null) {
            ERMimeTypeManager mimeTypeManager = new ERMimeTypeManager();
            NSArray mimeTypes = ERXProperties.componentsSeparatedByString((String)"er.attachment.mimeTypes", (String)",");
            NSArray additionalMimeTypes = ERXProperties.componentsSeparatedByString((String)"er.attachment.additionalMimeTypes", (String)",");
            if (additionalMimeTypes != null) {
                mimeTypes = mimeTypes.arrayByAddingObjectsFromArray(additionalMimeTypes);
            }
            for (String mimeType : mimeTypes) {
                String name = ERXProperties.stringForKeyWithDefault((String)("er.attachment.mimeType." + mimeType + ".name"), (String)mimeType);
                String uti = ERXProperties.stringForKeyWithDefault((String)("er.attachment.mimeType." + mimeType + ".uti"), null);
                NSArray extensions = ERXProperties.componentsSeparatedByString((String)("er.attachment.mimeType." + mimeType + ".extensions"), (String)",");
                mimeTypeManager.addMimeType(new ERMimeType(name, mimeType, uti, (NSArray<String>)extensions));
            }
            INSTANCE = mimeTypeManager;
        }
        return INSTANCE;
    }

    public static String primaryExtension(String mimeTypeStr) {
        ERMimeType mimeType = ERMimeTypeManager.mimeTypeManager().mimeTypeForMimeTypeString(mimeTypeStr, false);
        String extension = null;
        if (mimeType != null) {
            extension = mimeType.primaryExtension();
        }
        return extension;
    }

    private ERMimeTypeManager() {
    }

    public void clearMimeTypes() {
        this._mimeTypes.clear();
    }

    public void removeMimeType(ERMimeType mimeType) {
        this._mimeTypes.remove(mimeType);
    }

    public void addMimeType(ERMimeType mimeType) {
        this._mimeTypes.add(mimeType);
    }

    public String extensionForFileName(String fileName) {
        int dotIndex;
        String extension = null;
        if (fileName != null && (dotIndex = fileName.lastIndexOf(46)) != -1) {
            extension = fileName.substring(dotIndex + 1);
        }
        return extension;
    }

    public ERMimeType mimeTypeForFileName(String fileName, boolean exceptionIfNotFound) {
        return this.mimeTypeForExtension(this.extensionForFileName(fileName), exceptionIfNotFound);
    }

    public ERMimeType mimeTypeForFile(File file, boolean exceptionIfNotFound) {
        String extension = file == null ? null : this.extensionForFileName(file.getName());
        return this.mimeTypeForExtension(extension, exceptionIfNotFound);
    }

    public ERMimeType mimeTypeForMimeTypeString(String mimeType, boolean exceptionIfNotFound) {
        ERMimeType matchingMimeType = null;
        if (mimeType != null) {
            Iterator<ERMimeType> mimeTypesIter = this._mimeTypes.iterator();
            while (matchingMimeType == null && mimeTypesIter.hasNext()) {
                ERMimeType possibleMatchingMimeType = mimeTypesIter.next();
                if (!possibleMatchingMimeType.mimeType().equals(mimeType)) continue;
                matchingMimeType = possibleMatchingMimeType;
            }
            if (mimeType != null && mimeType.indexOf("*") != -1) {
                matchingMimeType = new ERGlobMimeType(mimeType);
            }
            if (exceptionIfNotFound && matchingMimeType == null) {
                throw new NoSuchElementException("There is no registered mime type for the type " + mimeType + ".");
            }
        }
        return matchingMimeType;
    }

    public ERMimeType mimeTypeForExtension(String extension, boolean exceptionIfNotFound) {
        ERMimeType matchingMimeType = null;
        if (extension != null) {
            String lowercaseExtension = extension.toLowerCase();
            Iterator<ERMimeType> mimeTypesIter = this._mimeTypes.iterator();
            while (matchingMimeType == null && mimeTypesIter.hasNext()) {
                ERMimeType mimeType = mimeTypesIter.next();
                if (!mimeType.isRepresentedByExtension(lowercaseExtension)) continue;
                matchingMimeType = mimeType;
            }
        }
        if (exceptionIfNotFound && matchingMimeType == null) {
            throw new NoSuchElementException("There is no registered mime type for the extension " + extension + ".");
        }
        return matchingMimeType;
    }

    public ERMimeType mimeTypeForUTI(String uti, boolean exceptionIfNotFound) {
        ERMimeType matchingMimeType = null;
        if (uti != null) {
            Iterator<ERMimeType> mimeTypesIter = this._mimeTypes.iterator();
            while (matchingMimeType == null && mimeTypesIter.hasNext()) {
                ERMimeType mimeType = mimeTypesIter.next();
                if (!uti.equals(mimeType.uti())) continue;
                matchingMimeType = mimeType;
            }
        }
        if (exceptionIfNotFound && matchingMimeType == null) {
            throw new NoSuchElementException("There is no registered mime type for the uti '" + uti + "'.");
        }
        return matchingMimeType;
    }
}

