/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded;

import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.CtField;
import javassist.gluonj.embedded.CtMethod;
import javassist.gluonj.embedded.Modifier;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.embedded.bytecode.BadBytecode;
import javassist.gluonj.embedded.bytecode.CodeAttribute;
import javassist.gluonj.embedded.bytecode.CodeIterator;
import javassist.gluonj.embedded.bytecode.ConstPool;
import javassist.gluonj.embedded.bytecode.MethodInfo;
import javassist.gluonj.embedded.convert.TransformAccessArrayField;
import javassist.gluonj.embedded.convert.TransformAfter;
import javassist.gluonj.embedded.convert.TransformBefore;
import javassist.gluonj.embedded.convert.TransformCall;
import javassist.gluonj.embedded.convert.TransformFieldAccess;
import javassist.gluonj.embedded.convert.TransformNew;
import javassist.gluonj.embedded.convert.TransformReadField;
import javassist.gluonj.embedded.convert.TransformWriteField;
import javassist.gluonj.embedded.convert.Transformer;

public class CodeConverter {
    protected Transformer transformers = null;

    public void replaceNew(CtClass newClass, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformNew(this.transformers, newClass.getName(), calledClass.getName(), calledMethod);
    }

    public void redirectFieldAccess(CtField field, CtClass newClass, String newFieldname) {
        this.transformers = new TransformFieldAccess(this.transformers, field, newClass.getName(), newFieldname);
    }

    public void replaceFieldRead(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformReadField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceFieldWrite(CtField field, CtClass calledClass, String calledMethod) {
        this.transformers = new TransformWriteField(this.transformers, field, calledClass.getName(), calledMethod);
    }

    public void replaceArrayAccess(CtClass calledClass, ArrayAccessReplacementMethodNames names) throws NotFoundException {
        this.transformers = new TransformAccessArrayField(this.transformers, calledClass.getName(), names);
    }

    public void redirectMethodCall(CtMethod origMethod, CtMethod substMethod) throws CannotCompileException {
        String d2;
        String d1 = origMethod.getMethodInfo2().getDescriptor();
        if (!d1.equals(d2 = substMethod.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("signature mismatch: " + substMethod.getLongName());
        }
        int mod1 = origMethod.getModifiers();
        int mod2 = substMethod.getModifiers();
        if (Modifier.isStatic(mod1) != Modifier.isStatic(mod2) || Modifier.isPrivate(mod1) && !Modifier.isPrivate(mod2) || origMethod.getDeclaringClass().isInterface() != substMethod.getDeclaringClass().isInterface()) {
            throw new CannotCompileException("invoke-type mismatch " + substMethod.getLongName());
        }
        this.transformers = new TransformCall(this.transformers, origMethod, substMethod);
    }

    public void redirectMethodCall(String oldMethodName, CtMethod newMethod) throws CannotCompileException {
        this.transformers = new TransformCall(this.transformers, oldMethodName, newMethod);
    }

    public void insertBeforeMethod(CtMethod origMethod, CtMethod beforeMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformBefore(this.transformers, origMethod, beforeMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    public void insertAfterMethod(CtMethod origMethod, CtMethod afterMethod) throws CannotCompileException {
        try {
            this.transformers = new TransformAfter(this.transformers, origMethod, afterMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    protected void doit(CtClass clazz, MethodInfo minfo, ConstPool cp) throws CannotCompileException {
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null || this.transformers == null) {
            return;
        }
        Transformer t = this.transformers;
        while (t != null) {
            t.initialize(cp, codeAttr);
            t = t.getNext();
        }
        CodeIterator iterator = codeAttr.iterator();
        while (iterator.hasNext()) {
            try {
                int pos = iterator.next();
                t = this.transformers;
                while (t != null) {
                    pos = t.transform(clazz, pos, iterator, cp);
                    t = t.getNext();
                }
            }
            catch (BadBytecode e) {
                throw new CannotCompileException(e);
            }
        }
        int locals = 0;
        t = this.transformers;
        while (t != null) {
            int s = t.extraLocals();
            if (s > locals) {
                locals = s;
            }
            t = t.getNext();
        }
        t = this.transformers;
        while (t != null) {
            t.clean();
            t = t.getNext();
        }
        codeAttr.setMaxLocals(codeAttr.getMaxLocals() + locals);
    }

    public static interface ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead();

        public String byteOrBooleanWrite();

        public String charRead();

        public String charWrite();

        public String doubleRead();

        public String doubleWrite();

        public String floatRead();

        public String floatWrite();

        public String intRead();

        public String intWrite();

        public String longRead();

        public String longWrite();

        public String objectRead();

        public String objectWrite();

        public String shortRead();

        public String shortWrite();
    }

    public static class DefaultArrayAccessReplacementMethodNames
    implements ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead() {
            return "arrayReadByteOrBoolean";
        }

        public String byteOrBooleanWrite() {
            return "arrayWriteByteOrBoolean";
        }

        public String charRead() {
            return "arrayReadChar";
        }

        public String charWrite() {
            return "arrayWriteChar";
        }

        public String doubleRead() {
            return "arrayReadDouble";
        }

        public String doubleWrite() {
            return "arrayWriteDouble";
        }

        public String floatRead() {
            return "arrayReadFloat";
        }

        public String floatWrite() {
            return "arrayWriteFloat";
        }

        public String intRead() {
            return "arrayReadInt";
        }

        public String intWrite() {
            return "arrayWriteInt";
        }

        public String longRead() {
            return "arrayReadLong";
        }

        public String longWrite() {
            return "arrayWriteLong";
        }

        public String objectRead() {
            return "arrayReadObject";
        }

        public String objectWrite() {
            return "arrayWriteObject";
        }

        public String shortRead() {
            return "arrayReadShort";
        }

        public String shortWrite() {
            return "arrayWriteShort";
        }
    }
}

