/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded.bytecode;

import javassist.gluonj.embedded.bytecode.AlignmentException;
import javassist.gluonj.embedded.bytecode.BadBytecode;
import javassist.gluonj.embedded.bytecode.ByteArray;
import javassist.gluonj.embedded.bytecode.CodeAttribute;
import javassist.gluonj.embedded.bytecode.ConstPool;
import javassist.gluonj.embedded.bytecode.ExceptionTable;
import javassist.gluonj.embedded.bytecode.LineNumberAttribute;
import javassist.gluonj.embedded.bytecode.LocalVariableAttribute;
import javassist.gluonj.embedded.bytecode.Opcode;
import javassist.gluonj.embedded.bytecode.StackMapTable;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    private static final int[] opcodeLength;

    static {
        int[] nArray = new int[202];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[16] = 2;
        nArray[17] = 3;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = 3;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[23] = 2;
        nArray[24] = 2;
        nArray[25] = 2;
        nArray[26] = 1;
        nArray[27] = 1;
        nArray[28] = 1;
        nArray[29] = 1;
        nArray[30] = 1;
        nArray[31] = 1;
        nArray[32] = 1;
        nArray[33] = 1;
        nArray[34] = 1;
        nArray[35] = 1;
        nArray[36] = 1;
        nArray[37] = 1;
        nArray[38] = 1;
        nArray[39] = 1;
        nArray[40] = 1;
        nArray[41] = 1;
        nArray[42] = 1;
        nArray[43] = 1;
        nArray[44] = 1;
        nArray[45] = 1;
        nArray[46] = 1;
        nArray[47] = 1;
        nArray[48] = 1;
        nArray[49] = 1;
        nArray[50] = 1;
        nArray[51] = 1;
        nArray[52] = 1;
        nArray[53] = 1;
        nArray[54] = 2;
        nArray[55] = 2;
        nArray[56] = 2;
        nArray[57] = 2;
        nArray[58] = 2;
        nArray[59] = 1;
        nArray[60] = 1;
        nArray[61] = 1;
        nArray[62] = 1;
        nArray[63] = 1;
        nArray[64] = 1;
        nArray[65] = 1;
        nArray[66] = 1;
        nArray[67] = 1;
        nArray[68] = 1;
        nArray[69] = 1;
        nArray[70] = 1;
        nArray[71] = 1;
        nArray[72] = 1;
        nArray[73] = 1;
        nArray[74] = 1;
        nArray[75] = 1;
        nArray[76] = 1;
        nArray[77] = 1;
        nArray[78] = 1;
        nArray[79] = 1;
        nArray[80] = 1;
        nArray[81] = 1;
        nArray[82] = 1;
        nArray[83] = 1;
        nArray[84] = 1;
        nArray[85] = 1;
        nArray[86] = 1;
        nArray[87] = 1;
        nArray[88] = 1;
        nArray[89] = 1;
        nArray[90] = 1;
        nArray[91] = 1;
        nArray[92] = 1;
        nArray[93] = 1;
        nArray[94] = 1;
        nArray[95] = 1;
        nArray[96] = 1;
        nArray[97] = 1;
        nArray[98] = 1;
        nArray[99] = 1;
        nArray[100] = 1;
        nArray[101] = 1;
        nArray[102] = 1;
        nArray[103] = 1;
        nArray[104] = 1;
        nArray[105] = 1;
        nArray[106] = 1;
        nArray[107] = 1;
        nArray[108] = 1;
        nArray[109] = 1;
        nArray[110] = 1;
        nArray[111] = 1;
        nArray[112] = 1;
        nArray[113] = 1;
        nArray[114] = 1;
        nArray[115] = 1;
        nArray[116] = 1;
        nArray[117] = 1;
        nArray[118] = 1;
        nArray[119] = 1;
        nArray[120] = 1;
        nArray[121] = 1;
        nArray[122] = 1;
        nArray[123] = 1;
        nArray[124] = 1;
        nArray[125] = 1;
        nArray[126] = 1;
        nArray[127] = 1;
        nArray[128] = 1;
        nArray[129] = 1;
        nArray[130] = 1;
        nArray[131] = 1;
        nArray[132] = 3;
        nArray[133] = 1;
        nArray[134] = 1;
        nArray[135] = 1;
        nArray[136] = 1;
        nArray[137] = 1;
        nArray[138] = 1;
        nArray[139] = 1;
        nArray[140] = 1;
        nArray[141] = 1;
        nArray[142] = 1;
        nArray[143] = 1;
        nArray[144] = 1;
        nArray[145] = 1;
        nArray[146] = 1;
        nArray[147] = 1;
        nArray[148] = 1;
        nArray[149] = 1;
        nArray[150] = 1;
        nArray[151] = 1;
        nArray[152] = 1;
        nArray[153] = 3;
        nArray[154] = 3;
        nArray[155] = 3;
        nArray[156] = 3;
        nArray[157] = 3;
        nArray[158] = 3;
        nArray[159] = 3;
        nArray[160] = 3;
        nArray[161] = 3;
        nArray[162] = 3;
        nArray[163] = 3;
        nArray[164] = 3;
        nArray[165] = 3;
        nArray[166] = 3;
        nArray[167] = 3;
        nArray[168] = 3;
        nArray[169] = 2;
        nArray[172] = 1;
        nArray[173] = 1;
        nArray[174] = 1;
        nArray[175] = 1;
        nArray[176] = 1;
        nArray[177] = 1;
        nArray[178] = 3;
        nArray[179] = 3;
        nArray[180] = 3;
        nArray[181] = 3;
        nArray[182] = 3;
        nArray[183] = 3;
        nArray[184] = 3;
        nArray[185] = 5;
        nArray[187] = 3;
        nArray[188] = 2;
        nArray[189] = 3;
        nArray[190] = 1;
        nArray[191] = 1;
        nArray[192] = 3;
        nArray[193] = 3;
        nArray[194] = 1;
        nArray[195] = 1;
        nArray[197] = 4;
        nArray[198] = 3;
        nArray[199] = 3;
        nArray[200] = 5;
        nArray[201] = 5;
        opcodeLength = nArray;
    }

    protected CodeIterator(CodeAttribute ca) {
        this.codeAttr = ca;
        this.bytecode = ca.getCode();
        this.begin();
    }

    public void begin() {
        this.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    public void move(int index) {
        this.currentPos = index;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    public int byteAt(int index) {
        return this.bytecode[index] & 0xFF;
    }

    public void writeByte(int value, int index) {
        this.bytecode[index] = (byte)value;
    }

    public int u16bitAt(int index) {
        return ByteArray.readU16bit(this.bytecode, index);
    }

    public int s16bitAt(int index) {
        return ByteArray.readS16bit(this.bytecode, index);
    }

    public void write16bit(int value, int index) {
        ByteArray.write16bit(value, this.bytecode, index);
    }

    public int s32bitAt(int index) {
        return ByteArray.read32bit(this.bytecode, index);
    }

    public void write32bit(int value, int index) {
        ByteArray.write32bit(value, this.bytecode, index);
    }

    public void write(byte[] code, int index) {
        int len = code.length;
        int j = 0;
        while (j < len) {
            this.bytecode[index++] = code[j];
            ++j;
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    public int next() throws BadBytecode {
        int pos = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, pos);
        return pos;
    }

    public int lookAhead() {
        return this.currentPos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int skipThis) throws BadBytecode {
        this.begin();
        ConstPool cp = this.codeAttr.getConstPool();
        String thisClassName = this.codeAttr.getDeclaringClass();
        int nested = 0;
        while (this.hasNext()) {
            int mref;
            int index = this.next();
            int c = this.byteAt(index);
            if (c == 187) {
                ++nested;
                continue;
            }
            if (c != 183 || !cp.getMethodrefName(mref = ByteArray.readU16bit(this.bytecode, index + 1)).equals("<init>") || --nested >= 0) continue;
            if (skipThis < 0) {
                return index;
            }
            String cname = cp.getMethodrefClassName(mref);
            if (cname.equals(thisClassName) != skipThis > 0) break;
            return index;
        }
        this.begin();
        return -1;
    }

    public int insert(byte[] code) throws BadBytecode {
        int pos = this.currentPos;
        this.insert0(this.currentPos, code, false);
        return pos;
    }

    public void insert(int pos, byte[] code) throws BadBytecode {
        this.insert0(pos, code, false);
    }

    public int insertEx(byte[] code) throws BadBytecode {
        int pos = this.currentPos;
        this.insert0(this.currentPos, code, true);
        return pos;
    }

    public void insertEx(int pos, byte[] code) throws BadBytecode {
        this.insert0(pos, code, true);
    }

    private void insert0(int pos, byte[] code, boolean exclusive) throws BadBytecode {
        int len = code.length;
        if (len <= 0) {
            return;
        }
        this.insertGapCore(pos, len, exclusive);
        int j = 0;
        while (j < len) {
            this.bytecode[pos++] = code[j];
            ++j;
        }
    }

    public int insertGap(int length) throws BadBytecode {
        int pos = this.currentPos;
        this.insertGapCore(this.currentPos, length, false);
        return pos;
    }

    public int insertGap(int pos, int length) throws BadBytecode {
        return this.insertGapCore(pos, length, false);
    }

    public int insertExGap(int length) throws BadBytecode {
        int pos = this.currentPos;
        this.insertGapCore(this.currentPos, length, true);
        return pos;
    }

    public int insertExGap(int pos, int length) throws BadBytecode {
        return this.insertGapCore(pos, length, true);
    }

    private int insertGapCore(int pos, int length, boolean exclusive) throws BadBytecode {
        if (length <= 0) {
            return 0;
        }
        int cur = this.currentPos;
        byte[] c = CodeIterator.insertGap(this.bytecode, pos, length, exclusive, this.get().getExceptionTable(), this.codeAttr);
        int length2 = c.length - this.bytecode.length;
        if (cur >= pos) {
            this.currentPos = cur + length2;
        }
        this.codeAttr.setCode(c);
        this.bytecode = c;
        this.endPos = this.getCodeLength();
        this.updateCursors(pos, length2);
        return length2;
    }

    protected void updateCursors(int pos, int length) {
    }

    public void insert(ExceptionTable et, int offset) {
        this.codeAttr.getExceptionTable().add(0, et, offset);
    }

    public int append(byte[] code) {
        int size = this.getCodeLength();
        int len = code.length;
        if (len <= 0) {
            return size;
        }
        this.appendGap(len);
        byte[] dest = this.bytecode;
        int i = 0;
        while (i < len) {
            dest[i + size] = code[i];
            ++i;
        }
        return size;
    }

    public void appendGap(int gapLength) {
        byte[] code = this.bytecode;
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        int i = 0;
        while (i < codeLength) {
            newcode[i] = code[i];
            ++i;
        }
        i = codeLength;
        while (i < codeLength + gapLength) {
            newcode[i] = 0;
            ++i;
        }
        this.codeAttr.setCode(newcode);
        this.bytecode = newcode;
        this.endPos = this.getCodeLength();
    }

    public void append(ExceptionTable et, int offset) {
        ExceptionTable table = this.codeAttr.getExceptionTable();
        table.add(table.size(), et, offset);
    }

    static int nextOpcode(byte[] code, int index) throws BadBytecode {
        int opcode;
        try {
            opcode = code[index] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadBytecode("invalid opcode address");
        }
        try {
            int len = opcodeLength[opcode];
            if (len > 0) {
                return index + len;
            }
            if (opcode == 196) {
                if (code[index + 1] == -124) {
                    return index + 6;
                }
                return index + 4;
            }
            int index2 = (index & 0xFFFFFFFC) + 8;
            if (opcode == 171) {
                int npairs = ByteArray.read32bit(code, index2);
                return index2 + npairs * 8 + 4;
            }
            if (opcode == 170) {
                int low = ByteArray.read32bit(code, index2);
                int high = ByteArray.read32bit(code, index2 + 4);
                return index2 + (high - low + 1) * 4 + 8;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new BadBytecode(opcode);
    }

    static byte[] insertGap(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        try {
            return CodeIterator.insertGap0(code, where, gapLength, exclusive, etable, ca);
        }
        catch (AlignmentException e) {
            try {
                return CodeIterator.insertGap0(code, where, gapLength + 3 & 0xFFFFFFFC, exclusive, etable, ca);
            }
            catch (AlignmentException e2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    private static byte[] insertGap0(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca) throws BadBytecode, AlignmentException {
        StackMapTable smt;
        LocalVariableAttribute vta;
        LocalVariableAttribute va;
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        CodeIterator.insertGap2(code, where, gapLength, codeLength, newcode, exclusive);
        etable.shiftPc(where, gapLength, exclusive);
        LineNumberAttribute na = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
        if (na != null) {
            na.shiftPc(where, gapLength, exclusive);
        }
        if ((va = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable")) != null) {
            va.shiftPc(where, gapLength, exclusive);
        }
        if ((vta = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable")) != null) {
            vta.shiftPc(where, gapLength, exclusive);
        }
        if ((smt = (StackMapTable)ca.getAttribute("StackMapTable")) != null) {
            smt.shiftPc(where, gapLength, exclusive);
        }
        return newcode;
    }

    /*
     * Unable to fully structure code
     */
    private static void insertGap2(byte[] code, int where, int gapLength, int endPos, byte[] newcode, boolean exclusive) throws BadBytecode, AlignmentException {
        i = 0;
        j = 0;
        while (i < endPos) {
            block11: {
                block13: {
                    block12: {
                        block10: {
                            if (i == where) {
                                j2 = j + gapLength;
                                while (j < j2) {
                                    newcode[j++] = 0;
                                }
                            }
                            nextPos = CodeIterator.nextOpcode(code, i);
                            inst = code[i] & 255;
                            if ((153 > inst || inst > 168) && inst != 198 && inst != 199) break block10;
                            offset = code[i + 1] << 8 | code[i + 2] & 255;
                            offset = CodeIterator.newOffset(i, offset, where, gapLength, exclusive);
                            newcode[j] = code[i];
                            ByteArray.write16bit(offset, newcode, j + 1);
                            j += 3;
                            break block11;
                        }
                        if (inst != 200 && inst != 201) break block12;
                        offset = ByteArray.read32bit(code, i + 1);
                        offset = CodeIterator.newOffset(i, offset, where, gapLength, exclusive);
                        newcode[j++] = code[i];
                        ByteArray.write32bit(offset, newcode, j);
                        j += 4;
                        break block11;
                    }
                    if (inst != 170) break block13;
                    if (i != j && (gapLength & 3) != 0) {
                        throw new AlignmentException();
                    }
                    i0 = i;
                    i2 = (i & -4) + 4;
                    while (i0 < i2) {
                        newcode[j++] = code[i0++];
                    }
                    defaultbyte = CodeIterator.newOffset(i, ByteArray.read32bit(code, i2), where, gapLength, exclusive);
                    ByteArray.write32bit(defaultbyte, newcode, j);
                    lowbyte = ByteArray.read32bit(code, i2 + 4);
                    ByteArray.write32bit(lowbyte, newcode, j + 4);
                    highbyte = ByteArray.read32bit(code, i2 + 8);
                    ByteArray.write32bit(highbyte, newcode, j + 8);
                    j += 12;
                    i0 = i2 + 12;
                    i2 = i0 + (highbyte - lowbyte + 1) * 4;
                    while (i0 < i2) {
                        offset = CodeIterator.newOffset(i, ByteArray.read32bit(code, i0), where, gapLength, exclusive);
                        ByteArray.write32bit(offset, newcode, j);
                        j += 4;
                        i0 += 4;
                    }
                    break block11;
                }
                if (inst != 171) ** GOTO lbl76
                if (i != j && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                i0 = i;
                i2 = (i & -4) + 4;
                while (i0 < i2) {
                    newcode[j++] = code[i0++];
                }
                defaultbyte = CodeIterator.newOffset(i, ByteArray.read32bit(code, i2), where, gapLength, exclusive);
                ByteArray.write32bit(defaultbyte, newcode, j);
                npairs = ByteArray.read32bit(code, i2 + 4);
                ByteArray.write32bit(npairs, newcode, j + 4);
                j += 8;
                i0 = i2 + 8;
                i2 = i0 + npairs * 8;
                while (i0 < i2) {
                    ByteArray.copy32bit(code, i0, newcode, j);
                    offset = CodeIterator.newOffset(i, ByteArray.read32bit(code, i0 + 4), where, gapLength, exclusive);
                    ByteArray.write32bit(offset, newcode, j + 4);
                    j += 8;
                    i0 += 8;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    newcode[j++] = code[i++];
lbl76:
                    // 2 sources

                    ** while (i < nextPos)
                }
            }
            i = nextPos;
        }
    }

    private static int newOffset(int i, int offset, int where, int gapLength, boolean exclusive) {
        int target = i + offset;
        if (i < where) {
            if (where < target || exclusive && where == target) {
                offset += gapLength;
            }
        } else if (target < where || !exclusive && where == target) {
            offset -= gapLength;
        }
        return offset;
    }
}

