/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.bytecode.ClassInfo;
import javassist.gluonj.embedded.bytecode.ConstInfo;
import javassist.gluonj.embedded.bytecode.ConstInfoPadding;
import javassist.gluonj.embedded.bytecode.Descriptor;
import javassist.gluonj.embedded.bytecode.DoubleInfo;
import javassist.gluonj.embedded.bytecode.FieldrefInfo;
import javassist.gluonj.embedded.bytecode.FloatInfo;
import javassist.gluonj.embedded.bytecode.IntegerInfo;
import javassist.gluonj.embedded.bytecode.InterfaceMethodrefInfo;
import javassist.gluonj.embedded.bytecode.LongInfo;
import javassist.gluonj.embedded.bytecode.LongVector;
import javassist.gluonj.embedded.bytecode.MemberrefInfo;
import javassist.gluonj.embedded.bytecode.MethodrefInfo;
import javassist.gluonj.embedded.bytecode.NameAndTypeInfo;
import javassist.gluonj.embedded.bytecode.StringInfo;
import javassist.gluonj.embedded.bytecode.Utf8Info;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    HashMap classes;
    HashMap strings;
    int thisClassInfo;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final CtClass THIS = null;

    public ConstPool(String thisclass) {
        this.items = new LongVector();
        this.numOfItems = 0;
        this.addItem(null);
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.thisClassInfo = this.addClassInfo(thisclass);
    }

    public ConstPool(DataInputStream in) throws IOException {
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.thisClassInfo = 0;
        this.read(in);
    }

    void prune() {
        this.classes = new HashMap();
        this.strings = new HashMap();
    }

    public int getSize() {
        return this.numOfItems;
    }

    public String getClassName() {
        return this.getClassInfo(this.thisClassInfo);
    }

    public int getThisClassInfo() {
        return this.thisClassInfo;
    }

    void setThisClassInfo(int i) {
        this.thisClassInfo = i;
    }

    ConstInfo getItem(int n) {
        return (ConstInfo)this.items.elementAt(n);
    }

    public int getTag(int index) {
        return this.getItem(index).getTag();
    }

    public String getClassInfo(int index) {
        ClassInfo c = (ClassInfo)this.getItem(index);
        if (c == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(c.name));
    }

    public int getNameAndTypeName(int index) {
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(index);
        return ntinfo.memberName;
    }

    public int getNameAndTypeDescriptor(int index) {
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(index);
        return ntinfo.typeDescriptor;
    }

    public int getMemberClass(int index) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        return minfo.classIndex;
    }

    public int getMemberNameAndType(int index) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        return minfo.nameAndTypeIndex;
    }

    public int getFieldrefClass(int index) {
        FieldrefInfo finfo = (FieldrefInfo)this.getItem(index);
        return finfo.classIndex;
    }

    public String getFieldrefClassName(int index) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index);
        if (f == null) {
            return null;
        }
        return this.getClassInfo(f.classIndex);
    }

    public int getFieldrefNameAndType(int index) {
        FieldrefInfo finfo = (FieldrefInfo)this.getItem(index);
        return finfo.nameAndTypeIndex;
    }

    public String getFieldrefName(int index) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index);
        if (f == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(f.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getFieldrefType(int index) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index);
        if (f == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(f.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int getMethodrefClass(int index) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index);
        return minfo.classIndex;
    }

    public String getMethodrefClassName(int index) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        return this.getClassInfo(minfo.classIndex);
    }

    public int getMethodrefNameAndType(int index) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index);
        return minfo.nameAndTypeIndex;
    }

    public String getMethodrefName(int index) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getMethodrefType(int index) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int getInterfaceMethodrefClass(int index) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index);
        return minfo.classIndex;
    }

    public String getInterfaceMethodrefClassName(int index) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index);
        return this.getClassInfo(minfo.classIndex);
    }

    public int getInterfaceMethodrefNameAndType(int index) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index);
        return minfo.nameAndTypeIndex;
    }

    public String getInterfaceMethodrefName(int index) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getInterfaceMethodrefType(int index) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public Object getLdcValue(int index) {
        ConstInfo constInfo = this.getItem(index);
        Object value = null;
        value = constInfo instanceof StringInfo ? this.getStringInfo(index) : (constInfo instanceof FloatInfo ? (Number)new Float(this.getFloatInfo(index)) : (Number)(constInfo instanceof IntegerInfo ? (Number)new Integer(this.getIntegerInfo(index)) : (Number)(constInfo instanceof LongInfo ? (Number)new Long(this.getLongInfo(index)) : (Number)(constInfo instanceof DoubleInfo ? new Double(this.getDoubleInfo(index)) : null))));
        return value;
    }

    public int getIntegerInfo(int index) {
        IntegerInfo i = (IntegerInfo)this.getItem(index);
        return i.value;
    }

    public float getFloatInfo(int index) {
        FloatInfo i = (FloatInfo)this.getItem(index);
        return i.value;
    }

    public long getLongInfo(int index) {
        LongInfo i = (LongInfo)this.getItem(index);
        return i.value;
    }

    public double getDoubleInfo(int index) {
        DoubleInfo i = (DoubleInfo)this.getItem(index);
        return i.value;
    }

    public String getStringInfo(int index) {
        StringInfo si = (StringInfo)this.getItem(index);
        return this.getUtf8Info(si.string);
    }

    public String getUtf8Info(int index) {
        Utf8Info utf = (Utf8Info)this.getItem(index);
        return utf.string;
    }

    public int isConstructor(String classname, int index) {
        return this.isMember(classname, "<init>", index);
    }

    public int isMember(String classname, String membername, int index) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (this.getClassInfo(minfo.classIndex).equals(classname)) {
            NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
            if (this.getUtf8Info(ntinfo.memberName).equals(membername)) {
                return ntinfo.typeDescriptor;
            }
        }
        return 0;
    }

    public String eqMember(String membername, String desc, int index) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (this.getUtf8Info(ntinfo.memberName).equals(membername) && this.getUtf8Info(ntinfo.typeDescriptor).equals(desc)) {
            return this.getClassInfo(minfo.classIndex);
        }
        return null;
    }

    private int addItem(ConstInfo info) {
        this.items.addElement(info);
        return this.numOfItems++;
    }

    public int copy(int n, ConstPool dest, Map classnames) {
        if (n == 0) {
            return 0;
        }
        ConstInfo info = this.getItem(n);
        return info.copy(this, dest, classnames);
    }

    int addConstInfoPadding() {
        return this.addItem(new ConstInfoPadding());
    }

    public int addClassInfo(CtClass c) {
        if (c == THIS) {
            return this.thisClassInfo;
        }
        if (!c.isArray()) {
            return this.addClassInfo(c.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(c));
    }

    public int addClassInfo(String qname) {
        ClassInfo info = (ClassInfo)this.classes.get(qname);
        if (info != null) {
            return info.index;
        }
        int utf8 = this.addUtf8Info(Descriptor.toJvmName(qname));
        info = new ClassInfo(utf8, this.numOfItems);
        this.classes.put(qname, info);
        return this.addItem(info);
    }

    public int addNameAndTypeInfo(String name, String type) {
        return this.addNameAndTypeInfo(this.addUtf8Info(name), this.addUtf8Info(type));
    }

    public int addNameAndTypeInfo(int name, int type) {
        return this.addItem(new NameAndTypeInfo(name, type));
    }

    public int addFieldrefInfo(int classInfo, String name, String type) {
        int nt = this.addNameAndTypeInfo(name, type);
        return this.addFieldrefInfo(classInfo, nt);
    }

    public int addFieldrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new FieldrefInfo(classInfo, nameAndTypeInfo));
    }

    public int addMethodrefInfo(int classInfo, String name, String type) {
        int nt = this.addNameAndTypeInfo(name, type);
        return this.addMethodrefInfo(classInfo, nt);
    }

    public int addMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new MethodrefInfo(classInfo, nameAndTypeInfo));
    }

    public int addInterfaceMethodrefInfo(int classInfo, String name, String type) {
        int nt = this.addNameAndTypeInfo(name, type);
        return this.addInterfaceMethodrefInfo(classInfo, nt);
    }

    public int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new InterfaceMethodrefInfo(classInfo, nameAndTypeInfo));
    }

    public int addStringInfo(String str) {
        return this.addItem(new StringInfo(this.addUtf8Info(str)));
    }

    public int addIntegerInfo(int i) {
        return this.addItem(new IntegerInfo(i));
    }

    public int addFloatInfo(float f) {
        return this.addItem(new FloatInfo(f));
    }

    public int addLongInfo(long l) {
        int i = this.addItem(new LongInfo(l));
        this.addItem(new ConstInfoPadding());
        return i;
    }

    public int addDoubleInfo(double d) {
        int i = this.addItem(new DoubleInfo(d));
        this.addItem(new ConstInfoPadding());
        return i;
    }

    public int addUtf8Info(String utf8) {
        Utf8Info info = (Utf8Info)this.strings.get(utf8);
        if (info != null) {
            return info.index;
        }
        info = new Utf8Info(utf8, this.numOfItems);
        this.strings.put(utf8, info);
        return this.addItem(info);
    }

    public Set getClassNames() {
        HashSet<String> result = new HashSet<String>();
        LongVector v = this.items;
        int size = this.numOfItems;
        int i = 1;
        while (i < size) {
            String className = ((ConstInfo)v.elementAt(i)).getClassName(this);
            if (className != null) {
                result.add(className);
            }
            ++i;
        }
        return result;
    }

    public void renameClass(String oldName, String newName) {
        LongVector v = this.items;
        int size = this.numOfItems;
        this.classes = new HashMap(this.classes.size() * 2);
        int i = 1;
        while (i < size) {
            ConstInfo ci = (ConstInfo)v.elementAt(i);
            ci.renameClass(this, oldName, newName);
            ci.makeHashtable(this);
            ++i;
        }
    }

    public void renameClass(Map classnames) {
        LongVector v = this.items;
        int size = this.numOfItems;
        this.classes = new HashMap(this.classes.size() * 2);
        int i = 1;
        while (i < size) {
            ConstInfo ci = (ConstInfo)v.elementAt(i);
            ci.renameClass(this, classnames);
            ci.makeHashtable(this);
            ++i;
        }
    }

    private void read(DataInputStream in) throws IOException {
        ConstInfo info;
        int n = in.readUnsignedShort();
        this.items = new LongVector(n);
        this.numOfItems = 0;
        this.addItem(null);
        while (--n > 0) {
            int tag = this.readOne(in);
            if (tag != 5 && tag != 6) continue;
            this.addItem(new ConstInfoPadding());
            --n;
        }
        int i = 1;
        while ((info = (ConstInfo)this.items.elementAt(i++)) != null) {
            info.makeHashtable(this);
        }
    }

    private int readOne(DataInputStream in) throws IOException {
        ConstInfo info;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 1: {
                info = new Utf8Info(in, this.numOfItems);
                this.strings.put(((Utf8Info)info).string, info);
                break;
            }
            case 3: {
                info = new IntegerInfo(in);
                break;
            }
            case 4: {
                info = new FloatInfo(in);
                break;
            }
            case 5: {
                info = new LongInfo(in);
                break;
            }
            case 6: {
                info = new DoubleInfo(in);
                break;
            }
            case 7: {
                info = new ClassInfo(in, this.numOfItems);
                break;
            }
            case 8: {
                info = new StringInfo(in);
                break;
            }
            case 9: {
                info = new FieldrefInfo(in);
                break;
            }
            case 10: {
                info = new MethodrefInfo(in);
                break;
            }
            case 11: {
                info = new InterfaceMethodrefInfo(in);
                break;
            }
            case 12: {
                info = new NameAndTypeInfo(in);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + tag);
            }
        }
        this.addItem(info);
        return tag;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.numOfItems);
        LongVector v = this.items;
        int size = this.numOfItems;
        int i = 1;
        while (i < size) {
            ((ConstInfo)v.elementAt(i)).write(out);
            ++i;
        }
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter out) {
        int size = this.numOfItems;
        int i = 1;
        while (i < size) {
            out.print(i);
            out.print(" ");
            ((ConstInfo)this.items.elementAt(i)).print(out);
            ++i;
        }
    }
}

